<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
  <?php echo $__env->make('layouts.includes.adminlte.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-lg-12">
          <div class="template-demo">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb bg-dark">
                <li class="breadcrumb-item"><a href="#">Reports</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('staff.leads.show')); ?>">Leads</a></li>
              </ol>
            </nav>
            
          </div>
        </div>
        <!-- <div class="col-lg-3">
          <a href="<?php echo e(route('admin.staff.show')); ?>" class="btn btn-inverse-warning btn-fw float-right">Back</a>
        </div> -->
      </div>
      
    </div>
  </div>
  <div class="row">
    
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h4 class="card-title text-center">Leads Details </h4>
          <div class="table-responsive">
            <table class="table table-striped">
              <thead>
                
              </thead>
              <tbody>
                <tr>
                  <td class="py-1"> Assigned By </td>
                  <td class="pr-0 "><div class="badge badge-pill badge-outline-primary"><?php echo e($lead->assigned_by_user_name); ?></div></td>
                  <td class="py-1">City</td>
                  <td class="pr-0 text-right"><div class="badge badge-pill badge-outline-primary"><?php echo e($lead->city); ?></div></td>
                  
                </tr>
                <tr>
                  <td class="py-1">Name</td>
                  <td class="pr-0 "><div class="badge badge-pill badge-outline-primary"><?php echo e($lead->firstname); ?> <?php echo e($lead->lastname); ?></div></td>
                  <td class="py-1">State</td>
                  <td class="pr-0 text-right"><div class="badge badge-pill badge-outline-primary"><?php echo e($lead->state); ?></div>
                </td>
                
              </tr>
              <tr>
                <td class="py-1">Email</td>
                <td class="pr-0 "><div class="badge badge-pill badge-outline-primary"><?php echo e($lead->email); ?></div></td>
                <td class="py-1">Post Code</td>
                <td class="pr-0 text-right"><div class="badge badge-pill badge-outline-primary"><?php echo e($lead->post_code); ?></div></td>
                
              </tr>
              <tr>
                <td class=py-1">Contact No</td>
                <td class="pr-0 "><div class="badge badge-pill badge-outline-primary"><?php echo e($lead->contact_no); ?></div></td>
                <td class="py-1">Lead Source</td>
                <td class="pr-0 text-right"><div class="badge badge-pill badge-outline-primary"><?php echo e($lead->lead_source); ?></div></td>
                
              </tr>
              <tr>
                <td class="py-1">Address</td>
                <td class="pr-0"><div class="badge badge-pill badge-outline-primary"><?php echo e($lead->address); ?></div></td>
                <td class="py-1">Description</td>
                <td class="pr-0 text-right"><div class="badge badge-pill badge-outline-primary"><?php echo e($lead->lead_description); ?></div></td>
              </tr>
              
              
            </tbody>
          </table>
        </div>
        
      </div>
    </div>
    
  </div>
  <div class="col-lg-12">
    <div class="card">
      <div class="card-body ">
        
        <form class="form-sample"  role="form" method="POST" action="<?php echo e(route('staff.leads.call.store')); ?>" enctype="multipart/form-data">
          <input name="lead_id" type="hidden" class="form-control" value="<?php echo e($lead->id); ?>">
          <?php echo e(csrf_field()); ?>

          <div class="row">
            <div class="col-md-6">
              <div class="form-group row">
                <label class="col-sm-3 col-form-label">Subject</label>
                <div class="col-sm-9">
                  <input type="text" class="form-control" name="subject" placeholder="" required="required">
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group row">
                <label class="col-sm-3 col-form-label">Call Type</label>
                <div class="col-sm-9">
                  <select class="form-control" name="status" >
                    <option value="Inbound">Inbound</option>
                    <option value="Outbound">Outbound</option>
                    <option value="Planned">Planned</option>
                    <option value="Held">Held</option>
                    <option value="Not Held">Not Held</option>
                  </select>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-6">
              <div class="form-group row">
                <label class="col-sm-3 col-form-label">Date</label>
                <div class="col-sm-9">
                  <input type="text" class="form-control datepicker" id="start_date" name="start_date" autocomplete="off">
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group row">
                <label class="col-sm-3 col-form-label">Duration</label>
                <div class="col-sm-9">
                  
                  <select class="form-control" name="duration">
                    <option>Select Duration</option>
                    <option value="5 Minutes">5 Minutes</option>
                    <option value="15 Minutes">15 Minutes</option>
                    <option value="30 Minutes">30 Minutes</option>
                    <option value="1 hour">1 hour</option>
                    <option value="Greater than 1 hour">Greater than 1 hour</option>
                  </select>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-6">
              <div class="form-group row">
                <label class="col-sm-3 col-form-label">Follow Up</label>
                <div class="col-sm-9">
                  <select class="form-control" id="follow_up">
                    <option>Select</option>
                    <option value="Yes">Yes</option>
                    <option value="NO">No</option>
                  </select>
                
                </div>
              </div>
            </div>

             <div class="col-md-6" style="display: none;" id="follow_up_val">
              <div class="form-group row">
                <label class="col-sm-3 col-form-label">Follow Up Date</label>
                <div class="col-sm-9">
                   <input type="text" class="form-control datepicker" name="follow_up"  autocomplete="off">
                </div>
              </div>
            </div>
            </div>
             <div class="row">
            <div class="col-md-6">
              <div class="form-group row">
                <label class="col-sm-3 col-form-label">Description</label>
                <div class="col-sm-9">
                  <textarea class="form-control" name="description" maxlength="500" placeholder="Max lenght 500 characters only!"></textarea>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-lg-12 form-group  text-center">
              <input type="submit" class="btn btn-warning" value="Add Call">
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
  <div class="col-lg-12">
    <div class="card">
      <div class="card-body ">
        <form class="form-sample"  role="form" method="POST" action="<?php echo e(route('staff.leads.call.convert')); ?>" enctype="multipart/form-data">
          <input name="lead_id" type="hidden" class="form-control" value="<?php echo e($lead->id); ?>">
          <?php echo e(csrf_field()); ?>

          <div class="row">
             <div class="col-md-6">
              <div class="form-group row">
                <label class="col-sm-3 col-form-label">Product</label>
                <div class="col-sm-9">
                  <select class="form-control" name="insurance" id="insurance_id"  required="required">
                    <option value="">Select</option>
                    <?php $__currentLoopData = $insurances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$insurance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option data-id="<?php echo e($insurance->expire); ?>" data-name="<?php echo e($insurance->name); ?>" value="<?php echo e($insurance->id); ?>"><?php echo e($insurance->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                </div>
              </div>
            </div>

            <div class="col-md-6" style="display: none;">
              <div class="form-group row">
                <label class="col-sm-3 col-form-label">Expire</label>
                <div class="col-sm-9">
                  <input type="hidden" class="form-control" name="expire" id="expire" >
                   <input type="hidden" class="form-control" name="insurane_name" id="insurane">
                </div>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group row">
                <label class="col-sm-3 col-form-label">Premium</label>
                <div class="col-sm-9">
                  <input type="price" class="form-control" name="price"  required="required">
                </div>
              </div>
            </div>            
          </div>
        
          <div class="row">
            <div class="col-lg-6 form-group  text-center">
              <input type="submit" name="convert" class="btn btn-success" value="Convert To opportunity">
            </div>
            <!--<div class="col-lg-6 form-group  text-center">-->
            <!--  <input type="submit" name="convert" class="btn btn-info" value="Convert To sales">-->
              
            <!--</div>-->
            <div class="col-lg-6 form-group  text-center">
                <button
                  type="button"
                  class="btn btn-primary"
                  data-toggle="modal"
                  data-target="#convertToSalesModal"
                  id="btnConvertToSales"
                  data-lookup-url="<?php echo e(route('staff.leads.sales.lookup', ['id' => $lead->id])); ?>"
                  data-convert-url="<?php echo e(route('staff.leads.sales.convert', ['id' => $lead->id])); ?>">
                  Sales Conversion
                </button>
            </div>
          </div>
        </form>
        
        
        <div class="modal fade" id="convertToSalesModal" tabindex="-1" role="dialog" aria-labelledby="convertToSalesModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl" role="document">  
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="convertToSalesModalLabel">Convert to Sale (by Debit Note)</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">  
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
        
              <div class="modal-body">
                <div class="form-group">
                  <label for="debitNoteInput" class="form-label">Debit Note Number</label>
        
                  
                  <div class="input-group">
                    <input type="text" id="debitNoteInput" class="form-control" placeholder="Enter Debit Note (e.g., DC12345)">
                    <div class="input-group-append">
                      <button id="btnSearchDebitNote" class="btn btn-outline-secondary" type="button">Search</button>
                    </div>
                  </div>
                  <small id="debitNoteHelp" class="form-text text-muted">We’ll fetch the matching record from IES and show the details below.</small>
                </div>
        
                <div id="lookupAlert" class="alert d-none" role="alert"></div>
        
                <div id="lookupResult" class="border rounded p-3 d-none">
                  <h6 class="mb-3">Fetched Details</h6>
                  <div class="row">
                    <div class="col-md-4 mb-3">
                      <div class="small text-muted">Debit Note</div>
                      <div id="v_debit_note" class="font-weight-bold"></div> 
                    </div>
                    <div class="col-md-4 mb-3">
                      <div class="small text-muted">Policy Number</div>
                      <div id="v_policy_number" class="font-weight-bold"></div>
                    </div>
                    <div class="col-md-4 mb-3">
                      <div class="small text-muted">Transaction Date</div>
                      <div id="v_transaction_date" class="font-weight-bold"></div>
                    </div>
                    <div class="col-md-4 mb-3">
                      <div class="small text-muted">Effective Date</div>
                      <div id="v_effective_date" class="font-weight-bold"></div>
                    </div>
                    <div class="col-md-4 mb-3">
                      <div class="small text-muted">Gross Premium</div>
                      <div id="v_gross_premium" class="font-weight-bold"></div>
                    </div>
                    <div class="col-md-4 mb-3">
                      <div class="small text-muted">Net Premium</div>
                      <div id="v_net_premium" class="font-weight-bold"></div>
                    </div>
                    <div class="col-md-4 mb-3">
                      <div class="small text-muted">Commission</div>
                      <div id="v_commission" class="font-weight-bold"></div>
                    </div>
                    <div class="col-md-4 mb-3">
                      <div class="small text-muted">Client</div>
                      <div id="v_client" class="font-weight-bold"></div>
                    </div>
                    <div class="col-md-4 mb-3">
                      <div class="small text-muted">Agency</div>
                      <div id="v_agency" class="font-weight-bold"></div>
                    </div>
                    <div class="col-md-4 mb-3">
                  <div class="small text-muted">Geo Cover</div>
                  <div id="v_geocover" class="font-weight-bold"></div>
                </div>
                <div class="col-md-4 mb-3">
                  <div class="small text-muted">Policy Class</div>
                  <div id="v_polclass" class="font-weight-bold"></div>
                </div>
                <div class="col-md-4 mb-3">
                  <div class="small text-muted">Region</div>
                  <div id="v_region" class="font-weight-bold"></div>
                </div>

                    <div class="col-md-12 mb-2">
                      <div class="small text-muted">Narration</div>
                      <div id="v_narration" class="font-weight-bold"></div>
                    </div>
                  </div>
        
                  
                  <form id="finalizeForm" class="d-none">
                      <?php echo csrf_field(); ?>
                      <input type="hidden" name="debit_note"       id="f_debit_note">
                      <input type="hidden" name="policy_number"    id="f_policy_number">
                      <input type="hidden" name="transaction_date" id="f_transaction_date">
                      <input type="hidden" name="effective_date"   id="f_effective_date">
                      <input type="hidden" name="entry_date"       id="f_entry_date">
                      <input type="hidden" name="gross_premium"    id="f_gross_premium">
                      <input type="hidden" name="commission"       id="f_commission">
                      <input type="hidden" name="net_premium"      id="f_net_premium">
                      <input type="hidden" name="narration"        id="f_narration">
                      <input type="hidden" name="client"           id="f_client">
                      <input type="hidden" name="branch"           id="f_branch">
                      <input type="hidden" name="currency"         id="f_currency">
                      <input type="hidden" name="agency"           id="f_agency">
                      <input type="hidden" name="rate"             id="f_rate">
                      <input type="hidden" name="geocover"         id="f_geocover">
                      <input type="hidden" name="polclass"         id="f_polclass">
                      <input type="hidden" name="tgross"           id="f_tgross">
                      <input type="hidden" name="region"           id="f_region">
                    </form>

                </div>
              </div>
        
              <div class="modal-footer">
                <button type="button" class="btn btn-light" data-dismiss="modal" type="button">Close</button> 
                <button id="btnCompleteConversion" class="btn btn-success d-none" type="button">
                  Complete sale conversion
                </button>
              </div>
            </div>
          </div>
        </div>


      </div>
    </div>
  </div>
  
</div>
</div>
<script>
(function () {
  // Helpers
  const $ = (sel) => document.querySelector(sel);

  // Resolve CSRF token (from meta or fallback)
  const token = (document.querySelector('meta[name="csrf-token"]') || {}).getAttribute?.('content') || '<?php echo e(csrf_token()); ?>';

  // Elements
  const salesBtn     = $('#btnConvertToSales');
  const lookupBtn    = $('#btnSearchDebitNote');
  const completeBtn  = $('#btnCompleteConversion');
  const alertBox     = $('#lookupAlert');
  const resultBox    = $('#lookupResult');
  const finalizeForm = $('#finalizeForm');

  function showAlert(type, message) {
    alertBox.className = `alert alert-${type}`;
    alertBox.textContent = message;
    alertBox.classList.remove('d-none');
  }
  
  function hideAlert() { alertBox.classList.add('d-none'); }

  function setText(id, value) {
  const el = document.getElementById(id);
  if (el) el.textContent = value ?? '';
}

  function setVal(id, value) {
  const el = document.getElementById(id);
  if (el) el.value = value ?? '';
}

  function getPolicyClassText(code) {
      const map = {
        1:  'Motor',
        2:  'General Accident',
        3:  'Marine',
        4:  'Fire',
        5:  'Bond',
        6:  'Oil & Gas',
        7:  'Others',
        8:  'Engineering',
        9:  'Aviation',
        16: 'Health Insurance',
        18: 'Agriculture',
        19: 'Liability / WCA'
      };
      return map[code] || '';
  }

  function setPreview(data) {
  setText('v_debit_note',       data.debit_note);
  setText('v_policy_number',    data.policy_number);
  setText('v_transaction_date', data.transaction_date);
  setText('v_effective_date',   data.effective_date);
  setText('v_gross_premium',    data.gross_premium);
  setText('v_net_premium',      data.net_premium);
  setText('v_commission',       data.commission);
  // choose which field is correct for “client”
  setText('v_client',           data.insured);
  setText('v_agency',           data.agency);
  setText('v_narration',        data.narration);
  setText('v_geocover',         data.geocover);
  setText('v_polclass', getPolicyClassText(data.polclass));
  setText('v_tgross',           data.tgross);
  setText('v_region',           data.region);
}

  function setHidden(data) {
  setVal('f_debit_note',       data.debit_note);
  setVal('f_policy_number',    data.policy_number);
  setVal('f_transaction_date', data.transaction_date);
  setVal('f_effective_date',   data.effective_date);
  setVal('f_entry_date',       data.entry_date);
  setVal('f_gross_premium',    data.gross_premium);
  setVal('f_commission',       data.commission);
  setVal('f_net_premium',      data.net_premium);
  setVal('f_narration',        data.narration);
  setVal('f_client',           data.insured);
  setVal('f_branch',           data.branch);
  setVal('f_currency',         data.currency);
  setVal('f_agency',           data.agency);
  setVal('f_rate',             data.rate);
  setVal('f_geocover',         data.geocover);
  setVal('f_polclass', getPolicyClassText(data.polclass));
  setVal('f_tgross',           data.tgross);
  setVal('f_region',           data.region);
}


  // 1) When the Sales button is clicked, cache the routes from data-attrs
  salesBtn?.addEventListener('click', function (e) {
    // e.preventDefault(); // not needed now that type="button"
    window._leadRoutes = {
      lookup: this.getAttribute('data-lookup-url'),
      convert: this.getAttribute('data-convert-url')
    };
  });

  // 2) Lookup handler
  lookupBtn?.addEventListener('click', async function () {
    hideAlert();
    completeBtn?.classList.add('d-none');
    resultBox?.classList.add('d-none');

    const routes = window._leadRoutes || {};
    if (!routes.lookup) {
      showAlert('danger', 'Routes are not ready. Click the "Sales Conversion" button again.');
      return;
    }

    const debitNoteInput = $('#debitNoteInput');
    const debitNote = (debitNoteInput?.value || '').trim();
    if (!debitNote) {
      showAlert('warning', 'Please enter a Debit Note number.');
      return;
    }

    this.disabled = true;
    this.textContent = 'Searching...';

    try {
      const res = await fetch(routes.lookup, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': token,
          'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify({ debit_note: debitNote })
      });
      const json = await res.json();
      if (!res.ok || !json.ok) {
        throw new Error(json.message || 'Lookup failed.');
      }

      setPreview(json.data);
      setHidden(json.data);

      resultBox?.classList.remove('d-none');
      finalizeForm?.classList.remove('d-none');
      completeBtn?.classList.remove('d-none');
      hideAlert();
    } catch (err) {
      showAlert('danger', err.message);
    } finally {
      this.disabled = false;
      this.textContent = 'Search';
    }
  });

  // 3) Complete conversion handler
  completeBtn?.addEventListener('click', async function () {
    hideAlert();

    const routes = window._leadRoutes || {};
    if (!routes.convert) {
      showAlert('danger', 'Routes are not ready. Click the "Sales Conversion" button again.');
      return;
    }

    this.disabled = true;
    this.textContent = 'Converting...';

    try {
      const formData = new FormData(finalizeForm);
      const res = await fetch(routes.convert, {
        method: 'POST',
        headers: {
          'X-CSRF-TOKEN': token,
          'X-Requested-With': 'XMLHttpRequest'
        },
        body: formData
      });
      const json = await res.json();
      if (!res.ok || !json.ok) {
        throw new Error(json.message || 'Conversion failed.');
      }
      showAlert('success', 'Sale conversion completed.');
      // window.location.href = `/sales/${json.sale_id}`;
    } catch (err) {
      showAlert('danger', err.message);
    } finally {
      this.disabled = false;
      this.textContent = 'Complete sale conversion';
    }
  });
})();
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.includes.veritas.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/veritaskapital/veritaskapital.net/crm/resources/views/admin/staff/detail.blade.php ENDPATH**/ ?>