<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
  <?php echo $__env->make('layouts.includes.adminlte.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
   <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-lg-12">
          <div class="template-demo">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb bg-dark">
                <li class="breadcrumb-item"><a href="#">Reports</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.reports.opportunity.show')); ?>">Opportunities</a></li>
              </ol>
            </nav>            
          </div>
        </div>
        <div class="col-lg-3">
          
        </div>
      </div>      
    </div>
  </div>
  <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-12">
          <form class="form-sample"  role="form" method="POST" action="<?php echo e(route('admin.reports.opportunity.show')); ?>" enctype="multipart/form-data">
            <?php echo e(csrf_field()); ?>

            <input type="hidden" name="search" value="true">
            <div class="row">
              <div class="col-md-6">
                <div class="form-group row">
                  <label class="col-sm-3 col-form-label">Date From</label>
                  <div class="col-sm-9">
                    <input type="date" class="form-control " id="start_date" name="start_date" placeholder=" " required="required"   value="<?php echo e($start_date ?? ''); ?>" autocomplete="off">
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group row">
                  <label class="col-sm-3 col-form-label">Date To</label>
                  <div class="col-sm-9">
                    <input type="date" class="form-control " id="stop_date" name="stop_date" placeholder=" " required="required"   value="<?php echo e($stop_date ?? ''); ?>" autocomplete="off">
                  </div>
                </div>
              </div>
              
              
              <div class="col-lg-12 form-group  text-center">
                <input type="submit" class="btn btn-success" name="search" value="Search">
                <a href="<?php echo e(route('admin.reports.opportunity.show')); ?>" type="button" class="btn btn-light btn-icon-text" >Reset</a>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  <div class="card">
    <div class="card-body">
      <h4 class="card-title">Opportunity</h4>
      <a type="button" onclick="getExport()" class="btn btn-info">Export</a>
      <script>
        function getExport(){
          let start_date = document.getElementById('start_date').value
          let stop_date = document.getElementById('stop_date').value
          let link = `/admin/export/reports/opportunities?start_date=${start_date}&stop_date=${stop_date}`
          console.log(link)
          window.location.href= link
        }
    </script>
      <div class="row">
        <div class="col-12">
          <div class="table-responsive">
            <table id="order-listing" class="table">
              <thead>
                <tr>
                  <th>No.</th>
                  <th>Assigned By</th>
                  <th>Lead</th>
                  <th>Product</th>
                  <th>Premium</th>
                 
                </tr>
              </thead>
              <tbody>
                <?php  $counter = 1; ?>
                <?php $__currentLoopData = $opportunities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opportunity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                
                <tr>
                  <td><?php echo e($counter); ?></td>
                  <td><?php echo e($opportunity->assigned_by_user_name); ?></td>
                  <td><?php echo e($opportunity->name); ?> <?php echo e($opportunity->lname); ?></td>
                  <td><?php echo e($opportunity->insurance_name); ?></td>
                  <td>N<?php echo e(number_format($opportunity->price )); ?></td>
                  
                </tr>
                <?php  $counter ++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.includes.veritas.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/veritaskapital/veritaskapital.net/crm/resources/views/admin/reports/opportunities/index.blade.php ENDPATH**/ ?>