<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
  <?php echo $__env->make('layouts.includes.adminlte.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>  
  <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-lg-12">
          <div class="template-demo">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb bg-dark">
                <li class="breadcrumb-item"><a href="<?php echo e(route('adminDashboard')); ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('staff.mytasks.show')); ?>">My Tasks</a></li>
              </ol>
            </nav>
            
          </div>
        </div>
        
      </div>
    </div>
  </div>

  <div class="card">
    <div class="card-body">
      <form class="form-sample"  role="form" method="POST" action="<?php echo e(route('staff.mytasks.show')); ?>" enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

      
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <label class="col-sm-3 col-form-label">Date From<sup>*</sup></label>
              <div class="col-sm-9">
                <input type="date" class="form-control " id="start_date" name="start_date"  required="required"   value="<?php echo e($start_date ?? ''); ?>" autocomplete="off">
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group row">
              <label class="col-sm-3 col-form-label">Date To<sup>*</sup></label>
              <div class="col-sm-9">
                <input type="date" class="form-control " id="stop_date" name="stop_date" required="required"   value="<?php echo e($stop_date ?? ''); ?>" autocomplete="off">
              </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
                <select class="form-control" onchange="display(this.value)">
                <option value="">Add more filter</option>
                <!-- <option value="branch">Branch</option>
                <option value="cloname">Clo Name</option> -->
                <option value="assigned_by">Assigned By</option>

              </select>
            </div>
          </div>
          <div class="col-md-6" id="searchby">
            
          </div>
        </div>

        <div class="row">
          <div class="col-lg-12 form-group  text-center">
            <input type="submit" class="btn btn-primary" name="search" value="Search">
            <a href="<?php echo e(route('staff.mytasks.show')); ?>" class="btn btn-success">Reset</a>
          </div>
        </div>
      </form>      
    </div>
  </div>

  <div class="card">
    <div class="card-body">
      <h4 class="card-title">My Tasks</h4>
      <a type="button" onclick="getExport()" class="btn btn-info">Export</a>
      <script>
        function getExport(){
            // admin/reports/sales/crm/export
            let start_date = document.getElementById('start_date').value
            let stop_date = document.getElementById('stop_date').value
            let link = `/admin/staff/tasks/myTasks/export?start_date=${start_date}&stop_date=${stop_date}`
            console.log(link)
            window.location.href= link
          }
      </script>
      <div class="row">
        
        <div class="col-12">
          <div class="table-responsive">
            <table id="order-listing" class="table">
              <thead>
                <tr>
                  
                  <th>
                    
                    No.
                    
                  </th>
                  <th>
                    
                    Assigned By
                    
                  </th>

                  <th>
                    
                   Title
                    
                  </th>

                   <th>
                    
                   Description
                    
                  </th>

                    <th>
                    
                   Doc
                    
                  </th>
                  
                  <th>
                    
                    Status
                    
                  </th>

                   <th>
                    
                    Action
                    
                  </th>
                  
                  
                 
                </tr>
              </thead>
              <tbody>
                
                <?php  $counter = 1; ?>
                <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                
                <tr>
                  <td><?php echo e($counter); ?></td>
                  <td><?php echo e($task->assigned_by_user_name); ?></td>
                  <td><?php echo e($task->name); ?></td>
                  <td><?php echo e($task->description); ?></td>
                  <td><?php echo e($task->file); ?></td>
                  <td>
                    <?php if($task->status == 1): ?>
                    <span class="pull-right-container">
                      <div class="badge badge-info">In Progress</div>
                    </span>
                    <?php elseif($task->status == 2): ?>
                    <span class="pull-right-container">
                     <div class="badge badge-warning">Review</div>
                    </span>
                    <?php elseif($task->status == 3): ?>
                    <span class="pull-right-container">
                      <div class="badge badge-success">Completed</div>
                    </span>
                    <?php else: ?>
                    <span class="pull-right-container">
                      <div class="badge badge-success">Outbound</div>
                    </span>
                    <?php endif; ?>
                  </td>
                  <td>
                    <div class="tools">
                      <a href="<?php echo e(route('staff.mytasks.detail',$task->id)); ?>"><i class="fa fa-bars"></i></a>
                      
                      
                    </div>
                  </td>
                  
                </tr>
                <?php  $counter ++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<script>
  function display(val){
    // document.getElementById('searchby').css('display','visible');
    if(val=="assigned_by"){
      document.getElementById('searchby').innerHTML=`
        <div class="form-group row">
              <label class="col-sm-3 col-form-label">Name</label>
              <div class="col-sm-9">
                <input type="text" class="form-control " id="assigned_by" name="assigned_by" value="<?php echo e($assigned_by ?? ''); ?>">
              </div>
            </div>
      `
    }
    else{
      document.getElementById('searchby').innerHTML=`
      `
    }
  }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.includes.veritas.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/veritaskapital/veritaskapital.net/crm/resources/views/admin/staff/task/tasks.blade.php ENDPATH**/ ?>