<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
  <?php echo $__env->make('layouts.includes.adminlte.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
   <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-lg-12">
          <div class="template-demo">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb bg-dark">
                <li class="breadcrumb-item"><a href="#">Reports</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('teamLead.sales.show')); ?>">Sales</a></li>
                
                
              </ol>
            </nav>            
          </div>
        </div>
        <div class="col-lg-3">
          
        </div>
      </div>      
    </div>
  </div>

  <div class="card">
    <div class="card-body">
      <form class="form-sample"  role="form" method="POST" action="<?php echo e(route('teamLead.crm.sales.show')); ?>" enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

      
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <label class="col-sm-3 col-form-label">Date From<sup>*</sup></label>
              <div class="col-sm-9">
                <input type="date" class="form-control " id="effective_date" name="effective_date"  required="required"   value="<?php echo e($effective_date ?? ''); ?>" autocomplete="off">
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group row">
              <label class="col-sm-3 col-form-label">Date To<sup>*</sup></label>
              <div class="col-sm-9">
                <input type="date" class="form-control " id="expiration_date" name="expiration_date" required="required"   value="<?php echo e($expiration_date ?? ''); ?>" autocomplete="off">
              </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <select class="form-control" onchange="display(this.value)">
                <option value="">Add more filter</option>
                <option value="branch">Branch</option>
                <option value="agency">Agency</option>
                <option value="policyclass">Product Class</option>
                <option value="cloname">Clo Name</option>
                <option value="customer">Customer Name</option>
              </select>
            </div>
          </div>
          <div class="col-md-6" id="searchby">
            
          </div>
        </div>
        
       
        <div class="row">
          <div class="col-lg-12 form-group  text-center">
            <input type="submit" class="btn btn-primary" name="search" value="Search">
            <a href="<?php echo e(route('teamLead.crm.sales.show')); ?>" class="btn btn-success">Reset</a>
          </div>
        </div>
      </form>      
    </div>
  </div>

  <div class="card">
    <div class="card-body">
      <h4 class="card-title">Sales</h4>
      <a type="button" onclick="getExport()" class="btn btn-info">Export</a>
      <script>
        function getExport(){
            // admin/reports/sales/crm/export
            let start_date = document.getElementById('effective_date').value
            let stop_date = document.getElementById('expiration_date').value
            let link = `/admin/teamLead/leads/sales/crm/export?start_date=${start_date}&stop_date=${stop_date}`
            console.log(link)
            window.location.href= link
          }
      </script>
      <div class="row">
        <div class="col-12">
          <div class="table-responsive">
            <table id="order-listinga" class="table">
              <thead>
              <tr>
                  <th>No.</th>
                  <th>Clo</th>
                  <th>Staff Name</th>
                  <th>Product</th>
                  <th>Premium</th>                 
                  <th>Agency</th>
                  <th>Cover Period From</th>
                  <th>Cover Period To</th>
                  <th>Created At</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody>                
                <?php  $counter = 1; ?>
                <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>                
                <tr>
                  <td><?php echo e($counter); ?></td>
                  <td><?php echo e($sale->clo_id); ?></td>
                  <td><?php echo e($sale->name); ?></td>
                  <td><?php echo e($sale->insurance_name); ?></td>
                  <td><?php echo e($sale->price); ?></td>
                  <td><?php echo e($sale->agency); ?></td>
                  <td><?php echo e($sale->cover_period_from); ?></td>
                  <td><?php echo e($sale->cover_period_to); ?></td>
                  <td><?php echo e($sale->createdAt); ?></td>
                  <td><div class="tools">
                    <a href="<?php echo e(route('teamLead.sales.create',$sale->id)); ?>" title="Lead Details"  class="confirmAction">
                      <i class="fa fa-pencil"></i>
                    </a>
                </div>
              </td>
                </tr>
                <?php  $counter ++; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<script>
  function display(val){
    // document.getElementById('searchby').css('display','visible');
    if(val=="agency"){
      document.getElementById('searchby').innerHTML=`
        <div class="form-group row">
          <label class="col-sm-3 col-form-label">Agency</label>
          <div class="col-sm-9">
            <input type="text" class="form-control " id="agency" name="agency" value="<?php echo e($agency ?? ''); ?>">
          </div>
        </div>
      `
    }
    else if(val=="branch"){
      document.getElementById('searchby').innerHTML=`
          <div class="form-group row">
              <label class="col-sm-3 col-form-label">Branch</label>
              <div class="col-sm-9">
                <select class="form-control " id="branch" name="branch">
                <option value="<?php echo e($branch ?? ''); ?>"><?php echo e($branch ?? 'select an option'); ?>/>
                  <option value="Lagos">Lagos Head Office Annex</option>
                  <option value="Abuja">Abuja Head office</option>
                  <option value="Onitsha">Onitsha</option>
                  <option value="Kaduna">Kaduna</option>
                  <option value="Port-Harcourt">Port-Harcourt</option>
                  <option value="Ibadan">Ibadan</option>
                  <option value="Bauchi">Bauchi</option>
                </select>
              </div>
            </div>
      `
    }
    else if(val=="policyclass"){
      document.getElementById('searchby').innerHTML=`
        <div class="form-group row">
              <label class="col-sm-3 col-form-label">Policy Class</label>
              <div class="col-sm-9">
                <input type="text" class="form-control " id="pol_class" name="pol_class" value="<?php echo e($pol_class ?? ''); ?>">
              </div>
            </div>
      `
    }
    else if(val=="customer"){
      document.getElementById('searchby').innerHTML=`
        <div class="form-group row">
              <label class="col-sm-3 col-form-label">Customer name</label>
              <div class="col-sm-9">
                <input type="text" class="form-control " id="insured_name" name="insured_name" value="<?php echo e($insured_name ?? ''); ?>">
              </div>
            </div>
      `
    }
    else if(val=="cloname"){
      document.getElementById('searchby').innerHTML=`
          <div class="form-group row">
              <label class="col-sm-3 col-form-label">Clo Name</label>
              <div class="col-sm-9">
                <input type="text" class="form-control " id="clo_name" name="clo_name" value="<?php echo e($clo_name?? ''); ?>">
              </div>
            </div>
      `
    }
    else{
      document.getElementById('searchby').innerHTML=`
      `
    }
  }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.includes.veritas.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/veritaskapital/veritaskapital.net/crm/resources/views/admin/teamleads/sales/crm.blade.php ENDPATH**/ ?>