<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Veritas - Change Password</title>
    <!-- base:css -->
    <link rel="stylesheet" href="<?php echo e(asset('theme/template/vendors/mdi/css/materialdesignicons.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('theme/template/vendors/base/vendor.bundle.base.css')); ?>">
    <!-- endinject -->
    <!-- plugin css for this page -->
    <!-- End plugin css for this page -->
    <!-- inject:css -->
    <link rel="stylesheet" href="<?php echo e(asset('theme/template/css/vertical-layout-light/style.css')); ?>">
    <!-- endinject -->
    <link rel="shortcut icon" href="<?php echo e(asset('fav.png')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css"/>
  </head>
  <body class="sidebar-fixed">
    <div class="container-scroller">
      <div class="container-fluid page-body-wrapper full-page-wrapper">
        <div class="content-wrapper d-flex align-items-center auth px-0">

          <div class="row w-100 mx-0">
            <div class="col-lg-4 mx-auto">
              <div class="auth-form-light text-left py-5 px-4 px-sm-5">
                <div class="brand-logo">
                  <img style="height: 50px;  width: 150px;"  src="<?php echo e(asset('theme/template/images/logo.png')); ?>" alt="logo">
                </div>
                 <?php echo $__env->make('layouts.includes.adminlte.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <h3 class="font-weight-light">Change Password</h3>
                <form class="pt-3" method="POST" action="javascript:void(0)" id="frmChangePassword" name="frmChangePassword">
                  <?php echo csrf_field(); ?>
                  <!-- <input type="hidden" name="user_role" value="5"> -->
                   <div class="form-group">
                    <input id="old_password" type="password" class="form-control form-control-lg <?php $__errorArgs = ['old_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="old_password" required placeholder="Old Password">
                    <?php $__errorArgs = ['old_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback" role="alert">
                      <strong><?php echo e($message); ?></strong>
                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                  
                  <div class="form-group">
                    <input id="new_password" type="password" class="form-control form-control-lg <?php $__errorArgs = ['new_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="new_password" required placeholder="New Password">
                    <div id="password-strength-status"></div>
                    <?php $__errorArgs = ['new_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback" role="alert">
                      <strong><?php echo e($message); ?></strong>
                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                  
                  <div class="form-group">
                    <input id="cnew_password" type="password" class="form-control form-control-lg <?php $__errorArgs = ['cnew_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="cnew_password" required placeholder="Confirm New Password">
                    <div id="cpassword-strength-status"></div>
                    <?php $__errorArgs = ['cnew_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback" role="alert">
                      <strong><?php echo e($message); ?></strong>
                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                  <div class="mt-3">
                    <!--  <a class="btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn" href="../../index.html">SIGN IN</a> -->
                    <button type="button" id="btnChangePassword" name="btnChangePassword" class="btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn"><?php echo e(__('Proceed')); ?></button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
        <!-- content-wrapper ends -->
      </div>
      <!-- page-body-wrapper ends -->
    </div>
    <!-- container-scroller -->
    <!-- base:js -->
    <script src="<?php echo e(asset('theme/template/vendors/base/vendor.bundle.base.js')); ?>"></script>
    <!-- endinject -->
    <!-- inject:js -->
    <script src="<?php echo e(asset('theme/template/js/off-canvas.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/template/js/hoverable-collapse.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/template/js/template.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/template/js/settings.js')); ?>"></script>
    <script src="<?php echo e(asset('theme/template/js/todolist.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"></script>
    <script type="text/javascript">
		function checkPasswordStrength(password_field, display = "#password-strength-status") 
		{
		    var number = /([0-9])/;
		    var alphabets = /([a-zA-Z])/;
		    var special_characters = /([~,!,@,#,$,%,^,&,*,-,_,+,=,?,>,<])/;

		    if($(password_field).val().length<6) {
		        $(display).removeClass();
		        $(display).addClass('weak-password');
		        $(display).html("Weak (should be atleast 6 characters.)");
		        $('#btnChangePassword').hide();
		    } else {    
		        if($(password_field).val().match(number) && $(password_field).val().match(alphabets) && $(password_field).val().match(special_characters)) {            
		            $(display).removeClass();
		            $(display).addClass('strong-password');
		            $(display).html("Perfect!");
		            $('#btnChangePassword').show();
		        } else {
		            $(display).removeClass();
		            $(display).addClass('medium-password');
		            $(display).html("Medium (should include alphabets, numbers and special characters.)");
		            $('#btnChangePassword').hide();
		        }
		    }
		}

		function delay(callback, ms) 
		{
		    var timer = 0;
		    return function() {
		      var context = this, args = arguments;
		      clearTimeout(timer);
		      timer = setTimeout(function () {
		        callback.apply(context, args);
		      }, ms || 0);
		    };
		}

		function formatErrorMessage(jqXHR, exception) 
		{

		    if (jqXHR.status === 0) {
		        return ('Not connected.\nPlease verify your network connection.');
		    } else if (jqXHR.status == 404) {
		        return ('The requested page not found. [404]');
		    } else if (jqXHR.status == 500) {
		        return ('Internal Server Error [500].');
		    } else if (exception === 'parsererror') {
		        return ('Requested JSON parse failed.');
		    } else if (exception === 'timeout') {
		        return ('Time out error.');
		    } else if (exception === 'abort') {
		        return ('Ajax request aborted.');
		    } else {
		        return ('Uncaught Error.\n' + jqXHR.responseText);
		    }
		}

		$('#new_password').keyup(delay(function (e) 
		{
	        //console.log('Time elapsed!', this.value);
	        var keywords = $('#new_password').val().trim();
	        if(keywords.length > 0){
	            checkPasswordStrength('#new_password');
	        }else{
	            $('#password-strength-status').html('');
	        }    
	    }, 500));
	    
	    $('#cnew_password').keyup(delay(function (e) 
		{
	        //console.log('Time elapsed!', this.value);
	        var pass = $('#new_password').val().trim();
	        var keywords = $('#cnew_password').val().trim();
	        if(keywords != pass){
	            $('#cpassword-strength-status').html('Password do not match');
	        }else{
	            $('#cpassword-strength-status').html('');
	        }    
	    }, 500));

	    $(document).on("click", "#btnChangePassword", function(e) {
	        e.preventDefault();

	        iziToast.info({title: 'Please wait...', message: '', timeout: 100000, position: 'topRight' });
	        
	        $("#btnChangePassword").hide();

	        var formData = $("#frmChangePassword").serializeArray();
	        
	        $.ajax({
	            url: "<?php echo e(route('password.policy.change')); ?>",
	            type: "POST",
	            data: formData,
	            dataType: "JSON",
	            success: function (response) {  
	                iziToast.destroy();     
	                //console.log(response);         
	                if(response.status.trim() == "success"){     
	                    iziToast.success({title: 'Hurraayy!', message: response.message, position: 'topRight' });
	                    window.location.href = "<?php echo e(route('adminDashboard')); ?>";
	                }else {
	                    iziToast.error({title: 'Error', message: ''+response.message, position: 'topRight' });
	                    $("#btnChangePassword").hide();
	                }
	            },
	            error: function(x,e) {
	                iziToast.destroy();
	                iziToast.error({title: 'Error', message: ''+formatErrorMessage(x, e), position: 'topRight' });
	                $("#btnChangePassword").hide();
	            }
	        })
	    });

		
	</script>
    <!-- endinject -->
  </body>
</html>

<?php /**PATH /home/veritaskapital/veritaskapital.net/crm/resources/views/change_password.blade.php ENDPATH**/ ?>