<?php

namespace App\Http\Controllers\Agent;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Routing\Route;
use App\Http\Controllers\Controller;
use App\Models\Agent;
use App\Models\Customer;
use App\Models\User;
use Validator;
use Auth;


class AgentController extends Controller
{

     public function dashboard() {
        $customers = Customer::count();
        $page_title  = 'Dashboard';
        return view('site/agent/dashboard', compact('customers','page_title'));
        
    }


    public function showProfile() {
    	$user = Agent::where('email','=',auth()->user()->email)->first(); 
        //dd($user);
        $page_title  = 'Agent Profile';
        return view('site/agent/profile', compact('user','page_title'));
        
    }


    public function profileUpdate(Request $request, $id) {
        
        $user = Agent::where('id', '=', $id)->first();
               
        $user->firstname = $request->name;
        $user->email = $request->email;

        $rules = $this->getRules($request, $user);

        if ($request->p1 != '' || $request->p2 != '') {
            if ($request->p1 != $request->p2) {
                $rules['password'] = 'required|min:6';
            }
        }
        $this->validate($request, $rules);

        if ($request->p1 != '' && $request->p2 != '') {
            if ($request->p1 == $request->p2) {
                $user->password = bcrypt($request->p1);
            }
        }
        if ($request->hasFile('image')) {
            $rules['image'] = 'image|mimes:png,jpg,gif,jpeg';
        }
        
        //$user->password = bcrypt($request->p1);       

       
        $user->save();

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "_users_$user->id." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/agent/'), $fileName);

            if ($user->image != 'photo.jpg' && is_file(public_path('uploads/site/users/' . $user->image))) {
                unlink(public_path('uploads/site/users/' . $user->image));
            }
            $user->image = $fileName;
        }

        $user->save();

        return redirect()->route('agent.profile.showprofile')->with('success', 'Profile update successfully');

    }

     public function getRules(Request $request, $admin)
    {
        $rules = ['name' => 'required'];
//        $rules['name'] = 'required|unique';
        //       $rules['email'] = 'required|unique';
        if ($admin) {
            if ($request->email && $admin->email != $request->email) {
                $rules['email'] = 'unique:users';
            }
        } else {
            $rules['email'] = 'unique:users';
        }
        return $rules;
    }
}
