<?php



namespace App\Http\Controllers\Admin\TeamLead;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\Lead;
use App\Models\User;
use App\Models\Policy;
use App\Models\CallActivity;
use App\Models\CustomerActivity;
use App\Models\ProspectsActivity;
use App\Models\CallingActivity;
use App\Models\AssignUser;
use Validator;
use Image;
use Auth;



class CallActivityController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Call Activity Reports';
    $start_date = $request->start_date;
    $stop_date = $request->stop_date;
    $follow_up = $request->follow_up;
    if($request->search == 'Search'){         
      if(isset($request->follow_up)){
        $staffs = AssignUser::where('user_id','=',Auth::user()->id)->get(); 
        foreach ($staffs as $key => $staff) {
            $ids[] = $staff['assign_user_id']; 
          }    

        array_push($ids, Auth::user()->id);   
        $activities = CallingActivity::whereBetween('callings.created_at',[$request->start_date, $request->stop_date])
                    ->whereIn('user_id', $ids)
                    ->where('callings.follow_up_date',$follow_up)
                    ->join('users', 'callings.user_id', '=', 'users.id')
                    ->select('callings.*','users.name','users.username','users.email')
                    ->get(); 
      }
      else{
        $staffs = AssignUser::where('user_id','=',Auth::user()->id)->get(); 
        foreach ($staffs as $key => $staff) {
            $ids[] = $staff['assign_user_id']; 
          }    

        array_push($ids, Auth::user()->id);   
        $activities = CallingActivity::whereBetween('callings.created_at',[$request->start_date, $request->stop_date])
                    ->whereIn('user_id', $ids)
                    ->join('users', 'callings.user_id', '=', 'users.id')
                    ->select('callings.*','users.name','users.username','users.email')
                    ->get(); 
      }
    }else{

      $staffs = AssignUser::where('user_id','=',Auth::user()->id)->get(); 
      foreach ($staffs as $key => $staff) {
          $ids[] = $staff['assign_user_id']; 
        }    

        array_push($ids, Auth::user()->id);   
        $activities = CallingActivity::whereIn('user_id', $ids)
                    ->join('users', 'callings.user_id', '=', 'users.id')
                    ->select('callings.*','users.name','users.username','users.email')
                    ->get(); 

    }   
    return view('admin/teamleads/callactivity/index', compact('page_title', 'activities','start_date','stop_date','follow_up'));    
   }


   public function getCallRecordsBySearch($request,$ids){
    return  CallingActivity::whereBetween('callings.created_at',[$request->start_date, $request->stop_date])
     ->whereIn('user_id', $ids)
     ->join('users', 'callings.user_id', '=', 'users.id')
     ->select('callings.*','users.name','users.username','users.email')
     ->get(); 

   }

   public function getCallRecords($ids){
    return  CallingActivity::whereIn('user_id', $ids)
     ->join('users', 'callings.user_id', '=', 'users.id')
     ->select('callings.*','users.name','users.username','users.email')
     ->get(); 

   }


    public function create(Request $request){                 
       $page_title = 'Add Call Notes';
       return view('admin/teamleads/callactivity/add', compact('page_title'));    
      }

     public function store(Request $request){ 
      if($request->date > date('Y-m-d')){
        //   dd("date cannot be more than today's date");
          return back()->with('error',"date cannot be more than today's date");
       }
       if(isset($request->follow_up_date) && $request->follow_up_date < date('Y-m-d')){
        //   dd("follow up date cannot be less than today's date");
        return back()->with('error',"follow up date cannot be less than today's date");
       }
      $Activity = new CallingActivity;
      $Activity->user_id = Auth::user()->id;
      $Activity->user_role = Auth::user()->user_role;
      $Activity->subject = $request->subject;
      $Activity->mode_of_activity = $request->mode_of_activity;
      $Activity->type_of_activity = $request->type_of_activity;
      $Activity->description = $request->description;
      $Activity->date = $request->date;      
      $Activity->follow_up = $request->follow_up;
      if($request->follow_up == "Yes"){
         $Activity->follow_up_date = $request->follow_up_date;  
      }else{
        $Activity->follow_up_date = $request->follow_up_date;  
      }
      
      $Activity->save();
      return redirect()->route('teamLead.reports.callactivity.show')->with('success', 'Call Add Successfully.');

            
   }

     public function show($id) {
        $activity = CallingActivity::where('id', '=', $id)->first(); 
         
        return view('admin/teamleads/callactivity/edit', compact('activity'));    
    }

     public function update(Request $request, $id) {
        //dd($request);
      $Activity = CallingActivity::where('id', '=', $id)->first();
      $Activity->user_id = Auth::user()->id;
      $Activity->user_role = Auth::user()->user_role;
      $Activity->subject = $request->subject;
      $Activity->mode_of_activity = $request->mode_of_activity;
      $Activity->description = $request->description;
      $Activity->date = $request->date;      
      $Activity->follow_up = $request->follow_up;
      if($request->follow_up == "Yes"){
         $Activity->follow_up_date = $request->follow_up_date;  
      }else{
        $Activity->follow_up_date = $request->follow_up_date;
      }
      
      $Activity->save();            

    return redirect()->route('teamLead.reports.callactivity.show')->with('success', 'Call Update Successfully .');
    }



   

     public function destroy($id) {
        $a = CallingActivity::find($id); 
        $a->delete(); //delete the User
        return redirect()->route('teamLead.reports.callactivity.show')->with('success', 'Call  Delete Successfully.');
    }

    
    public function exportCSV(Request $request){
      $fileName = ''; 
      $foundflag = false;
      $ids = [];
      $activities= [];
      $i         = 0;   
      
        $staffs = AssignUser::where('user_id','=',Auth::user()->id)->get();
      
     foreach ($staffs as $key => $staff) {
         $ids[] = $staff['assign_user_id']; 
      }    

    array_push($ids, Auth::user()->id); 

    if($request->input('start_date')!==null && $request->input('stop_date')!==null){
      // dd("callactivity");
        $fileName = 'callactivitybtw-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv';   
        $activities = CallingActivity::whereIn('user_id', $ids)
              ->whereBetween('callings.created_at',[$request->input('start_date'),$request->input('stop_date')])
              ->join('users', 'callings.user_id', '=', 'users.id')
              ->select('callings.*','users.name','users.username','users.email')
              ->get();
    }
    else{
      $fileName = 'callactivity.csv'; 
      $activities = CallingActivity::whereIn('user_id', $ids)
              ->join('users', 'callings.user_id', '=', 'users.id')
              ->select('callings.*','users.name','users.username','users.email')
              ->get();
    }
      
       $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Name', 'UserName','Email', 'Subject','Mode Of Activity','Date','Follow Up');

            $callback = function() use($activities, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($activities as $callActivity) {

                    if($callActivity->follow_up == 'Yes'){
                    $status = date('d-M-Y', strtotime($callActivity->follow_up_date));
                    }else{
                      $status = '';
                    }
                
                $row['Name']                    = $callActivity->name;
                $row['UserName']                = $callActivity->username;
                $row['Email']                   = $callActivity->email;
                $row['Subject']                 = $callActivity->subject;
                $row['Mode Of Activity']        = $callActivity->mode_of_activity;
                $row['Date']                    = $callActivity->date;
                $row['Follow Up']               = $status;
                
                
            fputcsv($file, array( $row['Name'], $row['UserName'], $row['Email'], $row['Subject'], $row['Mode Of Activity'], $row['Date'], $row['Follow Up']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }
    

}

