<?php



namespace App\Http\Controllers\Admin\TeamLead;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\User;
use App\Models\Lead;
use App\Models\CallActivity;
use App\Models\Opportunity;
use App\Models\Sale;
use Validator;
use Image;
use Auth;


class ActivityController extends Controller{    

    public function index(Request $request){     
    $page_title = 'Calls';    
    $follow_up= $request->follow_up;
    $start_date = $request->start_date;
    $stop_date = $request->stop_date;
    // dd($request);
    if($request->search == 'Search'){
        
        if(isset($request->follow_up)){
            $callActivities = CallActivity::where('call_activities.user_id','=',Auth::user()->id)
                            ->whereBetween('call_activities.created_at',[$request->start_date, $request->stop_date])
                            ->where('call_activities.follow_up_date',$request->follow_up)
                            ->join('users as u1', 'call_activities.user_id', '=', 'u1.id')
                            ->join('leads as l1', 'call_activities.lead_id', '=', 'l1.id')
                            ->select('call_activities.*','u1.name as staffname','l1.firstname as leadname')
                            ->get();
        }
        else{
            $callActivities = CallActivity::where('call_activities.user_id','=',Auth::user()->id)
                            ->whereBetween('call_activities.created_at',[$request->start_date, $request->stop_date])
                            ->join('users as u1', 'call_activities.user_id', '=', 'u1.id')
                            ->join('leads as l1', 'call_activities.lead_id', '=', 'l1.id')
                            ->select('call_activities.*','u1.name as staffname','l1.firstname as leadname')
                            ->get();
        }

    } 
    else{
        $callActivities = CallActivity::where('call_activities.user_id','=',Auth::user()->id)
                        ->join('users as u1', 'call_activities.user_id', '=', 'u1.id')
                        ->join('leads as l1', 'call_activities.lead_id', '=', 'l1.id')
                        ->select('call_activities.*','u1.name as staffname','l1.firstname as leadname')
                        ->get(); 
    }  
      
    // dd($callActivities);
    return view('admin/teamleads/calls/index', compact('page_title', 'callActivities','start_date','stop_date','follow_up'));    
   }


    public function create(Request $request,$id){                 
       $page_title = 'Add Call'; 
       return view('admin/teamleads/calls/add', compact('page_title','id'));    
      }

     public function store(Request $request){ 
      //dd($request);
      $CallActivity = new CallActivity;
      $CallActivity->user_id = Auth::user()->id;
      $CallActivity->lead_id = $request->lead_id;
      $CallActivity->subject = $request->subject;
      $CallActivity->start_date = $request->start_date;
      $CallActivity->follow_up = $request->follow_up;
      $CallActivity->duration = $request->duration;      
      $CallActivity->description = $request->description;
      $CallActivity->status = $request->status;

      $CallActivity->save();
     
      return redirect()->route('teamLead.assigned.leads.details',$request->lead_id)->with('success', 'Call Add Successfully.');

            
   }

 public function convert(Request $request){ 
     //dd($request);
      
      if($request->convert == 'Convert To opportunity'){      
      $Opportunity = new Opportunity;
      $Opportunity->user_id = Auth::user()->id;
      $Opportunity->lead_id = $request->lead_id;
      $Opportunity->insurance_id = $request->insurance;
      $Opportunity->insurance_name = $request->insurane_name;
      $Opportunity->price = $request->price;
      $Opportunity->expire = $request->expire;
      $Opportunity->save();
      $Lead = Lead::where('id', '=', $request->lead_id)->first(); 
      $Lead->status = 'Opportunity';
      $Lead->save();

      }else{

      $Sale = new Sale;
      $Sale->user_id = Auth::user()->id;
      $Sale->lead_id = $request->lead_id;
      $Sale->assigned_by_user_id = Lead::where('id','=',$request->lead_id)->pluck('assigned_by_user_id')->first();
      $Sale->insurance_id = $request->insurance;
      $Sale->insurance_name = $request->insurane_name;
      $Sale->price = $request->price;
      $Sale->expire = $request->expire;
      $Sale->save();
      $Lead = Lead::where('id', '=', $request->lead_id)->first();  
      $Lead->status = 'Progress';
      $Lead->save();
       
      return redirect()->route('teamLead.sales.create',$Sale->id)->with('success', 'Added Successfully.');
      }
          
      return redirect()->route('teamLead.assigned.leads.details',$request->lead_id)->with('success', 'Added Successfully.');

            
   }
     public function show($id) {
        $callActivity = CallActivity::where('id', '=', $id)->where('user_id', '=', Auth::user()->id)->first(); 
        //dd($callActivity);
        return view('admin/teamleads/calls/edit', compact('callActivity'));    
    }

     public function update(Request $request, $id) {
      //dd($request);
      $CallActivity = CallActivity::where('id', '=', $id)->first();
      $CallActivity->user_id = Auth::user()->id;
      $CallActivity->lead_id = $request->lead_id;
      $CallActivity->subject = $request->subject;
      $CallActivity->start_date = $request->start_date;
      $CallActivity->follow_up = $request->follow_up;
      $CallActivity->duration = $request->duration;      
      $CallActivity->description = $request->description;
      $CallActivity->status = $request->status;
      $CallActivity->save();
      

    return redirect()->route('teamLead.leads.call.show')->with('success', 'Call Update Successfully.');
    }

  

     public function destroy($id) {
        $c = CallActivity::find($id); 
        $c->delete();
        return redirect()->route('teamLead.leads.call.show')->with('success', 'Lead Call Delete Successfully.');
    }

     

    public function exportCSV(Request $request){
      $fileName = ''; 
      $foundflag = false;
      $array     = [];
      $callActivities=[];
      $i         = 0;   
    //   dd("activity");
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
        $fileName = 'callactivitybtw-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv';
       $callActivities = CallActivity::where('call_activities.user_id','=',Auth::user()->id)
                        ->whereBetween('call_activities.created_at',[$request->input('start_date'),$request->input('stop_date')])
                        ->join('users as u1', 'call_activities.user_id', '=', 'u1.id')
                        ->join('leads as l1', 'call_activities.lead_id', '=', 'l1.id')
                        ->select('call_activities.*','u1.name as staffname','l1.firstname as leadname')
                        ->get(); 
      }
      else{
        $fileName = 'callactivity.csv';
        $callActivities = CallActivity::where('call_activities.user_id','=',Auth::user()->id)
                        ->join('users as u1', 'call_activities.user_id', '=', 'u1.id')
                        ->join('leads as l1', 'call_activities.lead_id', '=', 'l1.id')
                        ->select('call_activities.*','u1.name as staffname','l1.firstname as leadname')
                        ->get(); 
      }
    
      
       $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Call BY', 'Lead Name', 'Subject','Call Date','Follow Up','Status');

            $callback = function() use($callActivities, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($callActivities as $callActivity) {
                
                $row['Call BY']          = $callActivity->staffname;
                $row['Lead Name']        = $callActivity->leadname;
                $row['Subject']          = $callActivity->subject;
                $row['Call Date']        = date('d-M-Y', strtotime($callActivity->start_date));
                $row['Follow Up']        = date('d-M-Y', strtotime($callActivity->follow_up));
                $row['Status']           = $callActivity->status;
                
                
            fputcsv($file, array( $row['Call BY'], $row['Lead Name'], $row['Subject'], $row['Call Date'], $row['Follow Up'], $row['Status']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }
    
    

}

