<?php



namespace App\Http\Controllers\Admin\Staff;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use App\Models\Task;
use App\Models\User;
use App\Models\Agency;
use App\Models\Account;
use App\Models\Lead;
use App\Models\Note;
use App\Helpers\EmailHelper;
use Validator;
use Image;
use Auth;


class TaskController extends Controller

{   


  public function index(Request $request){     
    $page_title = 'Tasks';
    $start_date = $request->start_date;
    $stop_date = $request->stop_date;   
   $assigned_by = $request->assigned_by;
   if($request->search == 'Search'){
     if(isset($request->assigned_by)){
        $tasks      = Task::where('assigned_by_user_id','=',Auth::user()->id)
                  ->whereBetween('tasks.created_at',[$start_date, $stop_date])
                  ->where('tasks.assigned_by_user_name','like',"%{$request->assigned_by}%")
                  ->join('users', 'tasks.user_id', '=', 'users.id')
                  ->select('tasks.*','users.name as assigned_username')
                  ->get();
     }
     else{
      $tasks      = Task::where('assigned_by_user_id','=',Auth::user()->id)
                  ->whereBetween('tasks.created_at',[$start_date, $stop_date])
                  ->join('users', 'tasks.user_id', '=', 'users.id')
                  ->select('tasks.*','users.name as assigned_username')
                  ->get();
     }
    }
    else{
      $tasks      = Task::where('assigned_by_user_id','=',Auth::user()->id)
                  ->join('users', 'tasks.user_id', '=', 'users.id')
                  ->select('tasks.*','users.name as assigned_username')
                  ->get();
    } 
     
    //dd($tasks);
    return view('admin/staff/task/index', compact('page_title', 'tasks','start_date','stop_date','assigned_by'));    
   }


    public function create(Request $request){                 
       $page_title = 'Add Task';
       /*$users = User::where('id','!=',Auth::user()->id)->get();*/
       $users = User::get();
      
       $brokers = Agency::where('agency_category_id','=',1)->get();
       $customers = Account::get();
       return view('admin/staff/task/add', compact('page_title','users','brokers','customers'));    
      }

     public function store(Request $request){ 
      
      $Task                = new Task;
      $Task->user_id       = $request->user_id;
      $Task->assigned_by_user_id = Auth::user()->id;
      $Task->assigned_by_user_name = Auth::user()->name;
      $Task->name          = $request->name;
      $Task->description   = $request->description;
      $Task->type          = $request->type;
      if($request->type == 'Broker'){
         $Task->task_type_name = implode(',', $request->task_type_name_broker); 
      }else if($request->type == 'Customer'){
         $Task->task_type_name = implode(',', $request->task_type_name_customer); 
      }
      $Task->save();
      
      if ($request->hasFile('file')) {
            $image = $request->file('file');
            $fileName = time() . "tasks." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/tasks/'), $fileName);

            if ($Task->file != 'photo.jpg' && is_file(public_path('uploads/site/tasks/' . $Task->file))) {
                unlink(public_path('uploads/site/tasks/' . $Task->file));
            }
            $Task->file = $fileName;
            $Task->save();
        }
     EmailHelper::sendEmailToTaskUser($Task->id);
     return redirect()->route('staff.tasks.show')->with('success', 'Task Add Successfully.');

            
   }

     public function show($id) {
        $task = Task::where('id', '=', $id)->first();   
        //$users = User::where('id','!=',Auth::user()->id)->get();
        $users = User::get();
        $brokers = Agency::where('agency_category_id','=',1)->get();
        $customers = Account::get();       
        return view('admin/staff/task/edit', compact('task','users','brokers','customers'));    
    }



     public function update(Request $request, $id) {
      $Task                = Task::where('id', '=', $id)->first();
      $Task->user_id       = $request->user_id;
      $Task->assigned_by_user_id = Auth::user()->id;
      $Task->assigned_by_user_name = Auth::user()->name;
      $Task->name          = $request->name;
      $Task->description   = $request->description;
      $Task->type          = $request->type;
      if($request->type == 'Broker'){
         $Task->task_type_name = implode(',', $request->task_type_name_broker); 
      }else if($request->type == 'Customer' ){
         $Task->task_type_name = implode(',', $request->task_type_name_customer); 
      }
      $Task->save();          
      return redirect()->route('staff.tasks.show')->with('success', 'Task Update Successfully .');
    }

      public function ShowNotesdetails($id) {
        $notes = Note::where('task_id', '=', $id)->get();           
        return view('admin/staff/task/notes', compact('notes'));    
    }

   

     public function destroy($id) {
        $c = Task::find($id); 
        $c->delete(); //delete the User
        return redirect()->route('staff.tasks.show')->with('success', 'Task Delete Successfully.');
    }



    public function mytasks(Request $request){     
         $page_title = 'My Tasks';
         Task::where('user_id','=',Auth::user()->id)->where('created_at','>=',date('Y-m-d'))->update(['notify_status'=>false]);
         $start_date = $request->start_date;
         $stop_date = $request->stop_date;   
         $assigned_by = $request->assigned_by;
         if($request->search == 'Search'){
            if(isset($request->assigned_by)){
               $tasks      = Task::where('user_id','=',Auth::user()->id)
                            ->whereBetween('tasks.created_at',[$start_date, $stop_date])
                            ->where('tasks.assigned_by_user_name','like',"%{$request->assigned_by}%")
                            ->get();
            }
            else{
               $tasks      = Task::where('user_id','=',Auth::user()->id)
                                 ->whereBetween('tasks.created_at',[$start_date, $stop_date])
                                 ->get();
            }
         }
         else{
            $tasks      = Task::where('user_id','=',Auth::user()->id)
                              ->get();
         }
           
         return view('admin/staff/task/tasks', compact('page_title', 'tasks','start_date','stop_date','assigned_by'));    
   } 


    public function details($id) {
        $task = Task::where('id', '=', $id)->first();   
        $notes = Note::where('task_id', '=', $id)->get();   
        
        return view('admin/staff/task/detail', compact('task','notes'));    
    }



    public function detailUpdate(Request $request,$id) {   
    
      $Task         = Task::where('id', '=', $id)->first();
      $Task->status = $request->status;
      $Task->save();   
      self::addNotes($request->note,$id);
      EmailHelper::sendEmailToTaskAssigner($Task->assigned_by_user_id,$request->status);
      return redirect()->route('staff.mytasks.show')->with('success', 'Task Status Update Successfully .');

    }
    

     public function addNotes($note,$id) {
      $Task = Task::where('id', '=', $id)->first();
      $Note = new Note;
      $Note->task_id = $id;
      $Note->user_id = $Task->user_id;
      $Note->assigned_by_user_id = $Task->assigned_by_user_id;
      $Note->assigned_by_user_name = $Task->assigned_by_user_name;
      $Note->note = $note;
      return $Note->save();   
      

     }

     public function getDownload($filename){
        $file_path = public_path('/uploads/site/tasks/'.$filename);
        return response()->download($file_path);

}

public function exportCsv(Request $request){
      $fileName = ''; 
      $foundflag = false;
      $array     = [];
      $tasks = [];
      $i         = 0;   
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
         $fileName = 'tasksbtw-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv';
         $tasks  = Task::where('assigned_by_user_id','=',Auth::user()->id)
                        ->whereBetween('tasks.created_at',[$request->input('start_date'),$request->input('stop_date')])
                        ->join('users', 'tasks.user_id', '=', 'users.id')
                        ->select('tasks.*','users.name as assigned_username')
                        ->get();
      }
      else{
         $fileName = 'tasks.csv';
         $tasks  = Task::where('assigned_by_user_id','=',Auth::user()->id)
                        ->join('users', 'tasks.user_id', '=', 'users.id')
                        ->select('tasks.*','users.name as assigned_username')
                        ->get();
      }

       $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Subject', 'Assigned To User');

            $callback = function() use($tasks, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($tasks as $task) {
                
                $row['Subject']        = $task['name'];
                $row['Assigned To User']  = $task['assigned_username'];
                
               
            fputcsv($file, array( $row['Subject'], $row['Assigned To User']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }
    
    public function exportCsv1(Request $request){
      $fileName = ''; 
      $foundflag = false;
      $array     = [];
      $tasks = [];
      $i         = 0;   
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
         $fileName = 'mytasks'.$request->input('start_date').'and'.$request->input('stop_date').'.csv';
         $tasks      = Task::where('user_id','=',Auth::user()->id)->whereBetween('tasks.created_at',[$request->input('start_date'),$request->input('stop_date')])->get();
      }
      else{
         $fileName = 'mytasks.csv';
         $tasks      = Task::where('user_id','=',Auth::user()->id)->get();
      }
       $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Assigned By', 'Title', 'Description', 'Doc','Status');

            $callback = function() use($tasks, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($tasks as $task) {
                
                $row['Assigned By'] = $task['assigned_by_user_name'];
                $row['Title']  = $task['name'];
                $row['Description'] = $task['description'];
                $row['Doc']  = $task['file'];
                if($task['status']==1){
                  $row['Status'] = "In Progress";
                }
                elseif($task['status']==2){
                  $row['Status'] = "Review";
                }elseif($task['status']==3){
                  $row['Status'] = "Completed";
                }
                else{
                  $row['Status'] = "Outbound";
                }
            fputcsv($file, array( $row['Assigned By'], $row['Title'],$row['Description'],$row['Doc'],$row['Status']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }

}

