<?php



namespace App\Http\Controllers\Admin\Reports;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\Lead;
use App\Models\User;
use App\Models\Policy;
use App\Models\Activity;
use App\Models\CustomerActivity;
use App\Models\ProspectsActivity;
use Validator;
use Image;
use Auth;



class CustomerActivityController extends Controller

{    

    public function index(Request $request){     
     $customers = CustomerActivity::get();     
       
    return view('admin/reports/customeractivity/index', compact('customers'));   
   }


    public function create(Request $request){                 
       $page_title = 'Add Call Notes';
       $customers  = Customer::get();
       return view('admin/reports/customeractivity/add', compact('page_title','customers'));    
      }

     public function store(Request $request){ 

      $Activity = new CustomerActivity;
      $Activity->lead_id = $request->lead_id;
      $Activity->lead_name = $request->lead_name;
      $Activity->lead_email = $request->lead_email;
      $Activity->lead_contact_no = $request->lead_contact_no;      
      $Activity->staff_id = Auth::user()->id;
      $Activity->staff_name = Auth::user()->firstname.' '.Auth::user()->lastname;
      $Activity->follow_up = $request->follow_up;
      $Activity->notes = $request->notes;      
      $Activity->appointment_time = date("h:i:s");
     // dd($Lead);
      $Activity->save();
      return redirect()->route('admin.reports.activity.show')->with('success', 'Call Notes Add Successfully.');

            
   }

     public function show($id) {
        $activity = CustomerActivity::where('id', '=', $id)->first(); 
        $customers  = Customer::get();  
        return view('admin/reports/customeractivity/edit', compact('activity','customers'));    
    }

     public function update(Request $request, $id) {
      $Activity = CustomerActivity::where('id', '=', $id)->first();
      $Activity->lead_id = $request->lead_id;
      $Activity->lead_name = $request->lead_name;
      $Activity->lead_email = $request->lead_email;
      $Activity->lead_contact_no = $request->lead_contact_no;      
      $Activity->staff_id = Auth::user()->id;
      $Activity->staff_name = Auth::user()->firstname.' '.Auth::user()->lastname;
      $Activity->follow_up = $request->follow_up;
      $Activity->notes = $request->notes;      
      $Activity->appointment_time = date("h:i:s");
     // dd($Lead);
      $Activity->save();            

    return redirect()->route('admin.reports.activity.show')->with('success', 'Call Note Update Successfully .');
    }



   

     public function destroy($id) {
        $a = CustomerActivity::find($id); 
        $a->delete(); //delete the User
        return redirect()->route('admin.reports.activity.show')->with('success', 'Customer Call Note Delete Successfully.');
    }

    
    
    

}

