<?php



namespace App\Http\Controllers\Admin\Management;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\BulkExport;
use App\Imports\BulkImport;

use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\User;
use App\Models\Policy;
use App\Models\Sale;
use Validator;
use Image;
use Carbon\Carbon;
use GuzzleHttp\Client;

class PolicyController extends Controller

{    

    public function renewals(Request $request){     
    $page_title = 'Policy Renewals';    
    

    $effective_date = '';
    $expiration_date = '';
    $premium = '';
    $insured_name = '';
    $branch = '';
    $agent = '';
    $pol_num = '';
    $pol_class = '';
    $clo_id = '';
    $clo_name = '';
    $cover_start = '';
    $cover_end = '';
    //dd($renewals->data);
    
  if($request->search == 'Search'){
      //dd($request);
      $client = new Client();
      $response = $client->request('POST', 'https://enterprise.veritaskapital.com/api/renewals',[
      'form_params' => [
          'effective_date' => $request->effective_date,
          'expiration_date' => $request->expiration_date,
          'sum_insured' => $request->premium,
          'insured_name' => $request->insured_name,
          'branch' => $request->branch,
          'agent' => $request->agency,
          'pol_num' => $request->pol_num,
          'pol_class' => $request->pol_class,
          'clo_id' => $request->clo_id,
          'clo_name' => $request->clo_name,
          'cover_start' => $request->cover_start,
          'cover_end' => $request->cover_end,
      ]]);
      $statusCode = $response->getStatusCode();
      $renewals = $response->getBody()->getContents();
      $renewals = json_decode($renewals);
      $array     = [];
      $i         = 0;
      foreach ($renewals->data as $renewal) {
          $insured_period = explode('To',$renewal->insured_period);
          $start_insured= $insured_period[0];
          $stop_insured = $insured_period[1];

          $array[$i]['customer_name'] = $renewal->customer_name;
          $array[$i]['policy_type'] = $renewal->policy_type;
          $array[$i]['clo_name'] = $renewal->clo_name;
          $array[$i]['policy_number'] = $renewal->policy_number;
          $array[$i]['sales_amount'] = number_format($renewal->sales_amount);
          $array[$i]['expiration_date'] = $renewal->expiration_date;
          $array[$i]['agency_name'] = $renewal->agency_name;
          $array[$i]['effective_date'] = $renewal->effective_date;
          $array[$i]['start_insured_period'] = $start_insured;
          $array[$i]['stop_insured_period'] = $stop_insured;
        
          $i++;
      }
      $renewals = $array;
      $effective_date = $request->effective_date;
      $expiration_date = $request->expiration_date;
      $premium = $request->premium;
      $insured_name = $request->insured_name;
      $branch = $request->branch;
      $agent = $request->agency;
      $pol_num = $request->pol_num;
      $pol_class = $request->pol_class;
      $clo_id = $request->clo_id;
      $clo_name = $request->clo_name;
      $cover_start = $request->cover_start;
      $cover_end = $request->cover_end;
    }else{

      $client = new Client();
      $response = $client->request('GET', 'https://enterprise.veritaskapital.com/api/renewals');
      $statusCode = $response->getStatusCode();
      $renewals = $response->getBody()->getContents();
      $renewals = json_decode($renewals);
      $array     = [];
      $i         = 0;
      foreach ($renewals->data as $renewal) {
          $insured_period = explode('To',$renewal->insured_period);
          $start_insured= $insured_period[0];
          $stop_insured = $insured_period[1];

          $array[$i]['customer_name'] = $renewal->customer_name;
          $array[$i]['policy_type'] = $renewal->policy_type;
          $array[$i]['clo_name'] = $renewal->clo_name;
          $array[$i]['policy_number'] = $renewal->policy_number;
          $array[$i]['sales_amount'] = number_format($renewal->sales_amount);
          $array[$i]['expiration_date'] = $renewal->expiration_date;
          $array[$i]['agency_name'] = $renewal->agency_name;
          $array[$i]['effective_date'] = $renewal->effective_date;
          $array[$i]['start_insured_period'] = $start_insured;
          $array[$i]['stop_insured_period'] = $stop_insured;
        
          $i++;
      }
      $renewals = $array;

    }

    return view('admin/managements/policy/index', compact('page_title', 'renewals','effective_date','expiration_date','premium','insured_name','branch','agent','pol_num','pol_class','clo_id','clo_name','cover_start','cover_end'));    
   }

   public function export(Request $request)     {
    //dd($id);
      $array     = [];

      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
              
        $fileName = 'Renewals-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv'; 
        $client = new Client();
        $response = $client->request('POST', 'https://enterprise.veritaskapital.com/api/renewals',[
        'form_params' => [
            'effective_date' => $request->input('start_date'),
            'expiration_date' => $request->input('stop_date'),
        ]]);
        $statusCode = $response->getStatusCode();
        $renewals = $response->getBody()->getContents();
        $renewals = json_decode($renewals);
        
        $i         = 0;
        foreach ($renewals->data as $renewal) {
            $insured_period = explode('To',$renewal->insured_period);
            $start_insured= $insured_period[0];
            $stop_insured = $insured_period[1];

            $array[$i]['customer_name'] = $renewal->customer_name;
            $array[$i]['policy_type'] = $renewal->policy_type;
            $array[$i]['clo_name'] = $renewal->clo_name;
            $array[$i]['policy_number'] = $renewal->policy_number;
            $array[$i]['sales_amount'] = number_format($renewal->sales_amount);
            $array[$i]['expiration_date'] = $renewal->expiration_date;
            $array[$i]['agency_name'] = $renewal->agency_name;
            $array[$i]['effective_date'] = $renewal->effective_date;
            $array[$i]['start_insured_period'] = $start_insured;
            $array[$i]['stop_insured_period'] = $stop_insured;
          
            $i++;
        }

      }
      else{
        $fileName = 'Renewals.csv';
        $client = new Client();
        $response = $client->request('GET', 'https://enterprise.veritaskapital.com/api/renewals');
        $statusCode = $response->getStatusCode();
        $renewals = $response->getBody()->getContents();
        $renewals = json_decode($renewals);
        
        $i         = 0;
        foreach ($renewals->data as $renewal) {
            $insured_period = explode('To',$renewal->insured_period);
            $start_insured= $insured_period[0];
            $stop_insured = $insured_period[1];

            $array[$i]['customer_name'] = $renewal->customer_name;
            $array[$i]['policy_type'] = $renewal->policy_type;
            $array[$i]['clo_name'] = $renewal->clo_name;
            $array[$i]['policy_number'] = $renewal->policy_number;
            $array[$i]['sales_amount'] = number_format($renewal->sales_amount);
            $array[$i]['expiration_date'] = $renewal->expiration_date;
            $array[$i]['agency_name'] = $renewal->agency_name;
            $array[$i]['effective_date'] = $renewal->effective_date;
            $array[$i]['start_insured_period'] = $start_insured;
            $array[$i]['stop_insured_period'] = $stop_insured;
          
            $i++;
        }

      }

        $headers = array(
          "Content-type"        => "text/csv",
          "Content-Disposition" => "attachment; filename=$fileName",
          "Pragma"              => "no-cache",
          "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
          "Expires"             => "0"
      );

      $columns = array('Customer Name', 'Policy Type', 'Clo Name','Policy Number','Sales Amount','Effective Date','Expiration Date','Agency Name','Start Insured','Stop Insured');

        $callback = function() use($array, $columns) {
              $file = fopen('php://output', 'w');
              fputcsv($file, $columns);

              foreach ($array as $renewal) {
                  
                  $row['Customer Name'] = $renewal['customer_name']; 
                  $row['Policy Type'] = $renewal['policy_type'];
                  $row['Clo Name'] = $renewal['clo_name'];
                  $row['Policy Number'] = $renewal['policy_number'];
                  $row['Sales Amount'] = $renewal['sales_amount'];
                  $row['Effective Date'] = $renewal['effective_date'];
                  $row['Expiration Date'] = $renewal['expiration_date'];
                  $row['Agency Name'] = $renewal['agency_name'];
                  $row['Start Insured'] = $renewal['start_insured_period'];
                  $row['Stop Insured'] = $renewal['stop_insured_period'];
                  
              fputcsv($file, array( $row['Customer Name'], $row['Policy Type'], $row['Clo Name'],$row['Policy Number'],$row['Sales Amount'],$row['Effective Date'],$row['Expiration Date'],$row['Agency Name'],$row['Start Insured'],$row['Stop Insured']));
              }

              fclose($file);
          };

          return response()->stream($callback, 200, $headers);
    }
   
    

}

