<?php



namespace App\Http\Controllers\Admin\Management\Business;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Account;
use App\Models\Contact;
use App\Models\AssignAccount;
use Validator;
use Image;
use Auth;



class AccountController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Business Accounts';    
    $accounts = Account::join('leads', 'leads.id', '=', 'accounts.lead_id')
    ->select('accounts.*','leads.firstname','leads.lastname','leads.email','leads.contact_no','leads.image')
    ->get();    
  //dd($accounts); 
       
    return view('admin/managements/business/index', compact('page_title','accounts'));    
   }


    public function create(Request $request){                 
       $page_title = 'Create Broker Account';
       //dd([$leads,$customers]);
       return view('admin/managements/business/add', compact('page_title'));    
      }

     public function store(Request $request){ 

      $Broker = new Broker;
      $Broker->name = $request->name;
      $Broker->email = $request->email;
      $Broker->contact_no = $request->contact_no;      
      $Broker->address = $request->address;      
      $Broker->save();
      return redirect()->route('management.business.account.show')->with('success', 'Account Create Successfully.');

            
   }

     public function show($id) {      
       $contacts = Contact::get();
       $account = Account::where('id','=', $id)->first();
       $assignAccounts = AssignAccount::where('assign_accounts.user_id','=',Auth::user()->id)->join('users', 'assign_accounts.user_id', '=', 'users.id')
       ->select('assign_accounts.*','users.name','users.lastname')
       ->get();
       //dd($assignAccounts);
       return view('admin/managements/business/edit', compact('contacts','account','assignAccounts'));    
    }

     public function update(Request $request, $id) {
      $Broker = Broker::where('id', '=', $id)->first();
      $Broker->name = $request->name;
      $Broker->email = $request->email;
      $Broker->contact_no = $request->contact_no;      
      $Broker->address = $request->address; 
      $Broker->save();            

    return redirect()->route('management.business.account.show')->with('success', 'Account Update Successfully .');
    }
   

     public function destroy($id) {
        $a = Broker::find($id); 
        $a->delete(); //delete the User
        return redirect()->route('management.business.account.show')->with('success', 'Account Delete Successfully.');
    }

     public function accountAssignToContact(Request $request) {
       // dd($request);
      $AssignAccount = new AssignAccount;
      $AssignAccount->user_id = Auth::user()->id;
      $AssignAccount->contact_id = $request->contact_id;
      $AssignAccount->contact_name = Contact::where('id','=',$request->contact_id)->pluck('name')->first();
      $AssignAccount->account_id = $request->account_id;
      $AssignAccount->account_name = $request->account_name;
      $AssignAccount->insurance_id = $request->insurance_id;      
      $AssignAccount->insurance_name = $request->insurance_name; 
      $AssignAccount->expire = $request->expire; 
      $AssignAccount->price = $request->price; 
      $AssignAccount->cover_period_from = $request->cover_period_from; 
      $AssignAccount->cover_period_to = $request->cover_period_to; 
      $AssignAccount->save();
      return redirect()->route('management.business.account.show')->with('success', 'Account Assign Successfully.'); 
    }


     public function exportCsv(Request $request){
      $fileName = 'accounts.csv';    
   

    $accounts = Account::join('leads', 'leads.id', '=', 'accounts.lead_id')
    ->select('accounts.*','leads.firstname','leads.lastname','leads.email','leads.contact_no','leads.image')
    ->get();   
    

   
        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

        $columns = array('Account Name', 'Account Email', 'Account Mobile NO');
       
            $callback = function() use($accounts, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($accounts as $account) {
                $row['Account Name']        = $account->firstname.' '.$account->lastname;
                $row['Account Email']       = $account->email;
                $row['Account Mobile NO']   = $account->contact_no;
                

                fputcsv($file, array( $row['Account Name'], $row['Account Email'], $row['Account Mobile NO']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }
    
    

}

