<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use App\Models\Email;
use App\Models\User;
use App\Models\Account;
use App\Models\Lead;
use App\Models\Opportunity;
use App\Models\Contact;
use App\Models\Sale;
use App\Mail\SendMail;
use Validator;
use Auth;


class EmailCampaigningController extends Controller
{

  public function index(){ 
    $emails = Email::get(); 
    return view('admin/campaign/index', compact('emails'));    

   }
    

  public function create(){ 
  $firstUsers = User::where('user_role','!=',Auth::user()->user_role)
  ->select('id','user_role','email','name','lastname')
  ->get()->toArray();

  $secondUsers = Contact::select('id','email','name')->get()->toArray();
  $users = array_merge($firstUsers,$secondUsers);
  return view('admin/campaign/add', compact('users'));    

   }

  public function store(Request $request){   
  
  foreach ($request['type'] as $key => $type) { 
   
   if($type == 'Lead'){
    $emails = Lead::select('email')->get();

   }else if($type == 'Account'){
    $emails = Account::join('leads', 'accounts.lead_id', '=', 'leads.id')->select('email')->get();

   }else if($type == 'Contacts'){
    $emails = Contact::select('email')->get();
    
   }else if($type == 'Renewals'){
    $emails = Sale::join('leads', 'sales.lead_id', '=', 'leads.id')->select('email')->get();
    
   }else if($type == 'Opportunity'){
    $emails = Opportunity::join('leads', 'opportunities.lead_id', '=', 'leads.id')->select('email')->get();    
   }    
  
   self::sendEmailToAllUsers($emails,$request->message, $type);
  }
   return redirect()->route('admin.email.campaign.show')->with('success', 'Email Sent.');  
     
  }

  


   public function sendEmailToAllUsers($emails,$message,$type){    
    
     if($type =='Lead'){
      $subject = 'Lead';

    }else if($type =='Account'){
      $subject = 'Account';

    }else if($type =='Contacts'){
      $subject = 'Contacts';
      
    }else if($type =='Renewals'){
      $subject = 'Policy Renewals';
      
    }else if($type =='Opportunity'){
      $subject = 'Opportunity';
      
    }

    foreach ($emails as $key => $email) {
       $data = array(
       'customer' => 'Customer',
       'name' => 'Demo Name',
       'email' => $email,
       'message' => $message,

    );
  } 
   

      $param = [
                'subject' => $subject,
                'from' => ['name' => env('MAIL_FROM_NAME'), 'address' => env('MAIL_FROM_ADDRESS')],
                'view' => 'emails/campaign_template',
                'data' => $data
            ];

   //dd( $data['email']->email);

    Mail::to($data['email'])->send(new SendMail($param));
   return true;
   }




}
