<?php



namespace App\Http\Controllers\Admin\Business;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Broker;
use App\Models\Contact;
use App\Models\BusinessLead;
use Validator;
use Image;
use Auth;



class LeadController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Business Lead';    
    $leads = BusinessLead::get();            
    return view('admin/business/lead/index', compact('page_title','leads'));    
   }


    public function create(Request $request){                 
       $page_title = 'Create Lead';
       return view('admin/business/lead/add', compact('page_title'));    
      }

     public function store(Request $request){ 

      $lead = new BusinessLead;
      $lead->name = $request->name;
      $lead->email = $request->email;
      $lead->contact_no = $request->contact_no;      
      $lead->company = $request->company;     
      $lead->address = $request->address;     
      $lead->city = $request->city;     
      $lead->state = $request->state;     
      $lead->zip_code = $request->zip_code;     
      $lead->country = $request->country;     
      $lead->annual_renevue = $request->annual_renevue;  
      $lead->description = $request->description;            
      $lead->save();
      return redirect()->route('admin.business.leads.show')->with('success', 'Business Lead Create Successfully.');

            
   }

     public function show($id) {
        $lead = BusinessLead::where('id', '=', $id)->first();         
        return view('admin/business/lead/edit', compact('lead'));    
    }

     public function update(Request $request, $id) {
      $lead = BusinessLead::where('id', '=', $id)->first();
      
      $lead->name = $request->name;
      $lead->email = $request->email;
      $lead->contact_no = $request->contact_no;      
      $lead->company = $request->company;     
      $lead->address = $request->address;     
      $lead->city = $request->city;     
      $lead->state = $request->state;     
      $lead->zip_code = $request->zip_code;     
      $lead->country = $request->country;     
      $lead->annual_renevue = $request->annual_renevue;  
      $lead->description = $request->description;            
      $lead->save();           

    return redirect()->route('admin.business.leads.show')->with('success', 'Business Lead Update Successfully .');
    }



   

     public function destroy($id) {
        $a = BusinessLead::find($id); 
        $a->delete(); //delete the User
        return redirect()->route('admin.business.leads.show')->with('success', 'Business Lead Delete Successfully.');
    }

    
    
    

}

