<?php



namespace App\Http\Controllers\Admin\Audit;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Helpers\EmailHelper;
use App\Helpers\UserHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\User;
use App\Models\Lead;
use App\Models\Insurance;
use App\Models\Opportunity;
use App\Models\Country;
use App\Models\Sale;
use App\Models\Agency;
use Validator;
use Image;
use Auth;


class SaleController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Sales';    
    $sales = Sale::where('sales.user_id','=',Auth::user()->id)
    ->join('users', 'users.id', '=', 'sales.user_id')
    ->select('sales.*','users.name as staffname', 'sales.created_at as createdAt')
    ->get();
    //dd($sales); 
    return view('admin/audit/sales/index', compact('page_title', 'sales'));    
   }

    public function create(Request $request,$id){ 
    $page_title = 'Convert To Sales'; 
    $sale = Sale::where('id', '=', $id)->first();
    $terms = UserHelper::daysInyears();
    $currencies = UserHelper::currency();
    
    $policyClasses = UserHelper::policyClasses();
    $policyBranches = UserHelper::policyBranches();
    $occupationalExposure = UserHelper::occupationalExposure();
    $businessLocations = UserHelper::businessLocations();
    $countries = Country::get();
    $agencyCategories = Agency::groupBy('agency_category_name')->get();
     
    return view('admin/audit/sales/add', compact('page_title','sale','id','terms','currencies','policyClasses','policyBranches','countries','occupationalExposure','businessLocations','agencyCategories'));            
        
    }

    public function store(Request $request){ 
    
      $Sale = Sale::where('id', '=', $request->id)->first();
      $Sale->user_id = $request->user_id;
      $Sale->lead_id = $request->lead_id;
      /*$Sale->insurance_id = $request->insurance_id;*/
      $Sale->insurance_no = $request->insurance_no;
      $Sale->client_code = $request->client_code;
      $Sale->agency_category_id = $request->agency_category_id;      
      $Sale->agency = $request->agency;      
      $Sale->insurance_class = $request->insurance_class;
      $Sale->insurance_type = $request->insurance_type;
      $Sale->business_type = $request->business_type;
      $Sale->insurance_group = $request->insurance_group;
      $Sale->reference = $request->reference;
      $Sale->currency = $request->currency;
      $Sale->rate = $request->rate;
      $Sale->issuance_date = $request->issuance_date;
      $Sale->term = $request->term;
      $Sale->cover_period_from = $request->cover_period_from;
      $Sale->cover_period_to = $request->cover_period_to;
      /*$Sale->limit_of_exposure = $request->limit_of_exposure;*/
      $Sale->insurance_branch = $request->insurance_branch;
      $Sale->business_location = $request->business_location;
      $Sale->geographical_cover = $request->geographical_cover;
      $Sale->occupational_exposure = $request->occupational_exposure;
      $Sale->insurance_status = $request->insurance_status;
      $Sale->save();

      if($Sale->insurance_status == 'Sale' || $Sale->insurance_status == 'Progress'){
        $account = EmailHelper::createAccount($Sale);
        EmailHelper::leadConvertToSale($request->lead_id);
    }

      $email = EmailHelper::sendEmailToUser($request);
      if($email == true){
        $Sale->email = $request->email;
        $Sale->email_sent = 'Yes';
        $Sale->save();
      

      }
      
      return redirect()->route('audit.sales.show')->with('success', 'Lead Convert to Sale Successfully.');  
   }

     public function show($id) {
        $sale = Sale::where('id', '=', $id)->first();
        //dd($sale);
        $terms = UserHelper::daysInyears();
        $currencies = UserHelper::currency();
        $agencies = UserHelper::agency();
        $policyClasses = UserHelper::policyClasses();
        $policyBranches = UserHelper::policyBranches();
        $occupationalExposure = UserHelper::occupationalExposure();
        $businessLocations = UserHelper::businessLocations();
        $countries = Country::get();
        $agencyCategories = Agency::get();
        return view('admin/audit/sales/edit', compact('sale','terms','currencies','agencies','policyClasses','policyBranches','countries','occupationalExposure','businessLocations','agencyCategories'));    
    }

    public function update(Request $request, $id) {
      
      $Sale = Sale::where('id', '=', $id)->first();
      $Sale->user_id = $request->user_id;
      $Sale->lead_id = $request->lead_id;
      /*$Sale->insurance_id = $request->insurance_id;*/
      $Sale->insurance_no = $request->insurance_no;
      $Sale->client_code = $request->client_code;
      $Sale->agency_category_id = $request->agency_category_id; 
      $Sale->agency = $request->agency;      
      $Sale->insurance_class = $request->insurance_class;
      $Sale->insurance_type = $request->insurance_type;
      $Sale->business_type = $request->business_type;
      $Sale->insurance_group = $request->insurance_group;
      $Sale->reference = $request->reference;
      $Sale->currency = $request->currency;
      $Sale->rate = $request->rate;
      $Sale->issuance_date = $request->issuance_date;
      $Sale->term = $request->term;
      $Sale->cover_period_from = $request->cover_period_from;
      $Sale->cover_period_to = $request->cover_period_to;
      /*$Sale->limit_of_exposure = $request->limit_of_exposure;*/
      $Sale->insurance_branch = $request->insurance_branch;
      $Sale->business_location = $request->business_location;
      $Sale->geographical_cover = $request->geographical_cover;
      $Sale->occupational_exposure = $request->occupational_exposure;
      $Sale->insurance_status = $request->insurance_status;
      $Sale->save();
      $email = EmailHelper::sendEmailToUser($request);
      if($email == true){
        $Sale->email = $request->email;
        $Sale->email_sent = 'Yes';
        $Sale->save();
      }
      if($Sale->insurance_status == 'Sale'){
        EmailHelper::leadConvertToSale($request->lead_id);
      }
    return redirect()->route('audit.sales.show')->with('success', 'Lead Convert to Sale Successfully.');  
    }


    public function destroy($id) {
      $c = Sale::find($id); 
      $c->delete();
        return redirect()->route('audit.sales.show')->with('success', 'Sale Delete Successfully.');
       
    }
    
   public function details($id){
     
    $page_title = 'Sales';    
    $sale = Sale::where('sales.id','=',$id)
    ->join('users', 'users.id', '=', 'sales.user_id')
    ->select('sales.*','users.name as staffname')
    ->first();
   // dd($sale);
    return view('admin/audit/sales/detail', compact('page_title', 'sale'));    
   }
    
   public function crmsales(Request $request){
    $page_title = "Sales Conversion";
      $insured_name = $request->insured_name;
      $pol_class = $request->pol_class;
      $clo_name = $request->clo_name;
      $agency = $request->agency;
      $branch = $request->branch;
      $effective_date = $request->effective_date;
      $expiration_date = $request->expiration_date;
    if($request->search == 'Search'){
      if(isset($request->branch)){
        $sales= Sale::join('users','users.id','=','sales.user_id')
                  
                 ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                 ->where('sales.insurance_branch',$request->branch)->get();
      }
      elseif(isset($request->agency)){
        $sales= Sale::join('users','users.id','=','sales.user_id')
                  
                 ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                 ->where('sales.agency','LIKE',"%{$request->agency}%")->get();
      }
      elseif(isset($request->clo_name)){
        $sales= Sale::join('users','users.id','=','sales.user_id')
                  
                 ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                 ->where(DB::raw('concat(users.firstname," ",users.lastname)'),'LIKE',"%{$request->clo_name}%")->get();
      }
      elseif(isset($request->pol_class)){
        $sales= Sale::join('users','users.id','=','sales.user_id')
                  
                 ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                 ->where('sales.insurance_name','LIKE',"%{$request->pol_class}%")->get();
      }
      elseif(isset($request->insured_name)){
        $sales= Sale::join('users','users.id','=','sales.user_id')
                  ->join('leads','leads.user_id','=','users.id')
                 ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                 ->where(DB::raw('concat(leads.firstname," ",leads.lastname)'),'LIKE',"%{$request->insured_name}%")->get();
      }
      else{
        $sales= Sale::join('users','users.id','=','sales.user_id')
                  
                 ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])->get();
      }
    }
    else{
      $sales= Sale::join('users','users.id','=','sales.user_id')
                  ->get();
    }
     return view('admin/audit/sales/crm',compact('page_title','sales','effective_date','expiration_date','insured_name','pol_class','clo_name','agency','branch'));
  }
    

}

