<?php



namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\Sale;
use App\Models\Opportunity;
use App\Models\Account;
use App\Models\Agency;
use App\Helpers\UserHelper;
use Validator;
use DB;
use Image;
use Auth;
use Carbon\Carbon;
use GuzzleHttp\Client;

class AdminController extends Controller

{

  public function __construct()
{
    $this->middleware('auth');
       
}

    public function index(Request $request)    {
     $role = Auth::user()->user_role;
      // dd($request['leadnotifier']);
      $users = Sale::select('id','price','created_at')           
            ->get()           
            ->groupBy(function($date) {
            //return Carbon::parse($date->created_at)->format('Y'); // grouping by years
            return Carbon::parse($date->created_at)->format('m'); // grouping by months
      });


      $usermcount = [];
      $sales = [];
      $totalCost = 0; 

      foreach ($users as $key => $value) {
        foreach($value as $k => $cost){
            $totalCost += $cost->price;
        }
        $usermcount[(int)$key] = $totalCost;
           
    }

   
    for($i = 1; $i <= 12; $i++){

    if(!empty($usermcount[$i])){
        $sales[$i] = $usermcount[$i];    
    }else{
        $sales[$i] = 0;    
    }
}
if($role == 6){

  $totalOpportunityCount = Opportunity::count('price');
    //dd($totalOpportunityCount);
    $totalOpportunitySum = Opportunity::sum('price');

}else{

  $totalOpportunityCount = Opportunity::where('user_id','=',Auth::user()->id)->count('price');
  $totalOpportunitySum = Opportunity::where('user_id','=',Auth::user()->id)->sum('price');

}

    
    $totalSaleCount = Sale::where('insurance_status','=','sale')->get('price');

    //$totalSale = Sale::where('insurance_status','=','sale')->sum('price');
   
    $client = new Client();
    $response = $client->request('GET', 'https://enterprise.veritaskapital.net/api/sales');
    $statusCode = $response->getStatusCode();
    $renewals = $response->getBody()->getContents();
    $renewals = json_decode($renewals);
 

    $totalSale = 0;
   
    foreach ($renewals->data as $key => $value) {

     $entry_date =  date('Y', strtotime($value->entry_date));
    
     if($value->clo == Auth::user()->clo_id && $entry_date == date('Y')){

       $totalSale+= $value->sales_amount;

     }else{

       $totalSale += 0;
     }
     
      
    }


   $sales = array();
   foreach($renewals->data as $k=>$val){

     $month = substr($val->entry_date, 0, 7);
     if (!isset($per_month[$month])) {
       $sales[$month] = 0;
     }
       $sales[$month] += $val->sales_amount;
    
    }

  
   
   if($role == 3 || $role == 4 || $role == 5 || $role == 6 || $role == 7 || $role == 8){
       $staffsTarget = UserHelper::getTargetsBasedOnUser(Auth::user()->clo_id);
      
   }else{
     $staffsTarget = 0;
   }



     return view('admin.dashboard', compact('sales','totalSale','totalSaleCount','totalOpportunityCount','totalOpportunitySum','staffsTarget'));
    

    }

    public function showprofile(Request $request) {
     $admin = Admin::where('id', '=', Auth::user()->id)->first(); 
     $page_title  = 'Admin Profile';
    return view('admin/profile/profile', compact('admin','page_title'));

    }

    public function profileUpdate(Request $request , $id) {
     
        $admin = Admin::where('id', '=', $id)->first();       
        $admin->name = $request->name;
        $admin->email = $request->email;

        $rules = $this->getRules($request, $admin);

        if ($request->p1 != '' || $request->p2 != '') {

            if ($request->p1 != $request->p2) {
                $rules['password'] = 'required|min:6';


            }
        }

         $this->validate($request, $rules);
        
   
        if ($request->p1 != '' && $request->p2 != '') {
            if ($request->p1 == $request->p2) {
                $admin->password = bcrypt($request->p1);
            }
        }
        if ($request->hasFile('image')) {
            $rules['image'] = 'image|mimes:png,jpg,gif,jpeg';
        }
        
        $admin->save();

        if(Auth::user()->user_role == 2){
        $path = 'uploads/site/admin/'.Auth::user()->user_role;
      }elseif(Auth::user()->user_role == 3){
         $path = 'uploads/site/staff/'.Auth::user()->user_role;
      }elseif(Auth::user()->user_role == 4){
         $path = 'uploads/site/teamLead/'.Auth::user()->user_role;
      }elseif(Auth::user()->user_role == 5){
         $path = 'uploads/site/supervisors/'.Auth::user()->user_role;
      }elseif(Auth::user()->user_role == 6){
         $path = 'uploads/site/management/'.Auth::user()->user_role;
      }elseif(Auth::user()->user_role == 7){
         $path = 'uploads/site/audit/'.Auth::user()->user_role;
      }elseif(Auth::user()->user_role == 8){
         $path = 'uploads/site/customerservice/'.Auth::user()->user_role;
      }else{
         $path = 'uploads/users/'.Auth::user()->user_role;
      }
      //dd($path);
      
         if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "user." . $image->getClientOriginalExtension();
            $image->move(public_path($path), $fileName);

            if ($admin->image != 'photo.jpg' && is_file(public_path($path . $admin->image))) {
                unlink(public_path($path . $admin->image));
            }
            
            $admin->avatar = $path .'/'.$fileName;
            $admin->image = $path .'/'.$fileName;
       }
 

         
             
        
        
        

        $admin->save();

        return redirect()->route('admin.profile.showprofile')->with('success', 'Profile update successfully');

    }

  

    public function aboutUsPage(Request $request){ 
        $aboutUsCMS = About::first();
        $page_title = 'Manage About Us';

     return view('admin/aboutus', compact('page_title', 'aboutUsCMS'));    
   }

     public function createAboutUsPage(Request $request){ 
      

      $aboutUsCMS = About::first();
         
      $aboutUsCMS->title = $request->get('title','');
      $aboutUsCMS->description = $request->get('description','');
      $aboutUsCMS->details_one = $request->get('detail_one','');
      $aboutUsCMS->details_two = $request->get('detail_two','');

      
      $aboutUsCMS->save();
       if ($request->hasFile('image_one')) {
            $image = $request->file('image_one');
            $fileName = time() . "aboutus." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/aboutus_cms/'), $fileName);

            if ($aboutUsCMS->image_one != 'photo.jpg' && is_file(public_path('uploads/aboutus_cms/' . $aboutUsCMS->image_one))) {
                unlink(public_path('uploads/aboutus_cms/' . $aboutUsCMS->image_one));
            }
            $aboutUsCMS->image_one = $fileName;
            $aboutUsCMS->save();
        }

         if ($request->hasFile('image_two')) {
            $image = $request->file('image_two');
            $fileName = time() . "aboutus." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/aboutus_cms/'), $fileName);

            if ($aboutUsCMS->image_two != 'photo.jpg' && is_file(public_path('uploads/aboutus_cms/' . $aboutUsCMS->image_two))) {
                unlink(public_path('uploads/aboutus_cms/' . $aboutUsCMS->image_two));
            }
            $aboutUsCMS->image_two = $fileName;
            $aboutUsCMS->save();
        }

         
      return redirect()->route('admin.aboutus')->with('success', 'saved');
          
   }

    public function galleryPage(Request $request){     
      return view('admin/gallery');   
    }

    public function servicesPage(Request $request){     
      return view('admin/services');   
    }

    public function contactUsPage(Request $request){    
      $ContactUsCMS = Contact::first();
        $page_title = 'Manage About Us';
 

      return view('admin/contact', compact( 'ContactUsCMS','page_title'));   
    }

     public function contactUsStore(Request $request){     

      $ContactUsCMS = Contact::first();
      $ContactUsCMS->title = $request->title;
      $ContactUsCMS->description = $request->description;               
      $ContactUsCMS->save();

     return redirect()->route('admin.contact')->with('success', 'saved');
  }

   public function footer(Request $request){ 
        $footerCMS = Footer::first();
        $page_title = 'Footer Content Management';
     return view('admin/footer', compact('page_title', 'footerCMS'));    
   }

   public function footerStore(Request $request){ 

       $footerCMS = Footer::first();
      $footerCMS->left_cms_content = $request->detail_one;
      $footerCMS->right_cms_content = $request->detail_two;
      $footerCMS->save();

     return redirect()->route('admin.footer.show')->with('success', 'saved');  
   }

    public function getRules(Request $request, $admin)
    {
        $rules = ['name' => 'required'];
//        $rules['name'] = 'required|unique';
        //       $rules['email'] = 'required|unique';
        if ($admin) {
            if ($request->email && $admin->email != $request->email) {
                $rules['email'] = 'unique:users';
            }
        } else {
            $rules['email'] = 'unique:users';
        }
        return $rules;
    }

   

public function searchShow(Request $request) {
    $q = $request->search;
   
    if( !empty( $q ) ) {
        $users = Account::where('account_name','LIKE','%'.$q.'%')->get();  

        if(count($users) > 0) {
           
          return view('admin.search',compact('users'));   

        } else { 

          $users = Agency::where('name','LIKE','%'.$q.'%')->get();
          
          return view('admin.search_1',compact('users'));

         if(count($users) > 0) {

         return redirect()->route('adminDashboard')->with('success', 'saved');

         }
      
        }
    } else { 
         return redirect()->route('adminDashboard')->with('success', 'No Record Found');
    }
}




     


    

}

