<?php

namespace App\Http\Controllers\Staff;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Routing\Route;
use App\Http\Controllers\Controller;
use App\Models\Staff;
use Validator;
use Auth;

class StaffController extends Controller
{
    
     public function dashboard() {
        $customers = Staff::count();
        $page_title  = 'Dashboard';
        return view('site/staff/dashboard', compact('customers','page_title'));
        
    }


    public function showProfile() {
    	$user = Staff::where('email','=',auth()->user()->email)->first(); 
        $page_title  = 'Staff Profile';
        return view('site/staff/profile', compact('user','page_title'));
        
    }


    public function profileUpdate(Request $request, $id) {
        
        $user = Staff::where('id', '=', $id)->first();
               
        $user->firstname = $request->name;
        $user->email = $request->email;

        $rules = $this->getRules($request, $user);

        if ($request->p1 != '' || $request->p2 != '') {
            if ($request->p1 != $request->p2) {
                $rules['password'] = 'required|min:6';
            }
        }
        $this->validate($request, $rules);

        if ($request->p1 != '' && $request->p2 != '') {
            if ($request->p1 == $request->p2) {
                $user->password = bcrypt($request->p1);
            }
        }
        if ($request->hasFile('image')) {
            $rules['image'] = 'image|mimes:png,jpg,gif,jpeg';
        }
        
        //$user->password = bcrypt($request->p1);       

       
        $user->save();

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "staffs." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/staffs/'), $fileName);

            if ($user->image != 'photo.jpg' && is_file(public_path('uploads/site/staffs/' . $user->image))) {
                unlink(public_path('uploads/site/staffs/' . $user->image));
            }
            $user->image = $fileName;
        }

        $user->save();

        return redirect()->route('staff.profile.showprofile')->with('success', 'Profile update successfully');

    }

     public function getRules(Request $request, $admin)
    {
        $rules = ['name' => 'required'];
//        $rules['name'] = 'required|unique';
        //       $rules['email'] = 'required|unique';
        if ($admin) {
            if ($request->email && $admin->email != $request->email) {
                $rules['email'] = 'unique:users';
            }
        } else {
            $rules['email'] = 'unique:users';
        }
        return $rules;
    }
}
