<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Routing\Route;
use App\Http\Controllers\Controller;
use App\Models\Customer;
use Validator;
use DB;
use Auth;


class SiteController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
    
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('site/index');
    }


     public function login()
    {
        return view('site/login');
    }

    

       public function signup(Request $request)
    {

        return view('site/register');
    }

       public function store(Request $request)
    {

        //dd($request);        
        $user = new Customer;
        //$user->user_role = 2;
        $user->firstname = $request->name;
        $user->email = $request->email;
        $user->phone_one = $request->mobile;
       
           $rules = $this->getRules($request, $user);
         if ($request->password != '' || $request->password_confirmation != '') {            
            if ($request->password != $request->password_confirmation) {
                $rules['password'] = 'required|min:6|confirmed';

            }
        }

        
        $this->validate($request, $rules);


        if ($request->password != '' && $request->password_confirmation != '') {
            if ($request->password == $request->password_confirmation) {
                $user->password = bcrypt($request->password);
            }
        }


        $user->save();
        return redirect()->route('userlogin')->with('success', 'Successfully register.Please try to Login.');
    }

       public function checkLogin(Request $request)
    {

        //dd($request);

    $this->validate($request, [
           'email'   => 'required|email',
           'password'  => 'required|alphaNum|min:3'
     ]);

         $user_data = array(
                'email'  => $request->get('email'),
                'password' => $request->get('password')
         );

       

        if(Auth::guard('customer')->attempt($user_data)) {
            
         return redirect()->route('customer.dashboard.show')->with('success', 'saved');
           }
          else
         {
          return back()->with('error', 'These credentials do not match our records.');
         }

}


    
 public function getRules(Request $request, $admin)
    {
        $rules = ['name' => 'required'];
//        $rules['name'] = 'required|unique';
        //       $rules['email'] = 'required|unique';
        if ($admin) {
            if ($request->email && $admin->email != $request->email) {
                $rules['email'] = 'unique:users';
            }
        } else {
            $rules['email'] = 'unique:users';
        }
        return $rules;
    }


 
}
