<?php

namespace App\Http\Controllers\Site;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Routing\Route;
use App\Http\Controllers\Controller;
use App\Http\Controllers\PasswordPolicy;
use App\Models\Staff;
use DB;
use Auth;

class StaffLoginController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    public function login()
    {
        return view('staff/login');
    }

    public function logout(Request $request)
    {
        Auth::logout();
        return redirect()->route('staffLogin');
    }

    public function signup(Request $request)
    {

        return view('staff/register');
    }

    public function store(Request $request)
    {

        //dd($request);        
        $user = new Staff;
        $user->firstname = $request->name;
        $user->email = $request->email;
        $user->phone_one = $request->mobile;

        $rules = $this->getRules($request, $user);
        if ($request->password != '' || $request->password_confirmation != '') {
            if ($request->password != $request->password_confirmation) {
                $rules['password'] = 'required|min:6|confirmed';
            }
        }


        $this->validate($request, $rules);


        if ($request->password != '' && $request->password_confirmation != '') {
            if ($request->password == $request->password_confirmation) {
                $user->password = bcrypt($request->password);
            }
        }


        $user->save();
        return redirect()->route('staffLogin')->with('success', 'saved');
    }

    public function checkLogin(Request $request)
    {

        //dd($request);

        $this->validate($request, [
            'email'   => 'required|email',
            'password'  => 'required|alphaNum|min:3'
        ]);

        $user_data = array(
            'email'  => $request->get('email'),
            'password' => $request->get('password')

        );


        if (Auth::guard('staff')->attempt($user_data)) {
            // dd($user_data);
            
            return redirect()->route('staff.profile.showprofile')->with('success', 'saved');
            
        } else {
            return back()->with('error', 'These credentials do not match our records.');
        }
    }

    public function resetPassword(Request $request)
    {
        //dd('sdsd');
        $page_title  = 'Reset Password';
        return view('staff/resetPassword', compact('page_title'));
    }

    public function checkUserIfExist(Request $request)
    {

        $Agent = Staff::where('email', '=', $request->email)->first();
        //dd($Agent);

        if ($Agent != NULL && $request->email == $Agent->email) {
            $page_title  = 'Update Password';
            $id       = $Agent->id;

            return redirect()->route('staff.password.update', ['id' => $id])->with('success', 'saved');
            // return view('site/agent/updatePassword', compact('page_title','id'));

        } else {

            return back()->withErrors(['email' => 'User does not exist with this email.']);
        }


        $page_title  = 'Reset Password';
        return view('staff/resetPassword', compact('page_title'));
    }

    public function updatePassword(Request $request, $id)
    {
        $page_title  = 'Reset Password';
        return view('staff/updatePassword', compact('page_title', 'id'));
    }

    public function generatePassword(Request $request)
    {

        $user = Staff::where('id', '=', $request->id)->first();


        if ($request->p1 != '' || $request->p2 != '') {
            if ($request->p1 != $request->p2) {
                return back()->withErrors(['password' => 'Password and Re-type password must be same.']);
            }
        }

        if ($request->p1 != '' && $request->p2 != '') {
            //dd($request);
            if ($request->p1 == $request->p2) {
                $user->password = bcrypt($request->p1);
            }
        }


        //$user->password = bcrypt($request->p1);       

        //dd($user);
        $user->save();
        return redirect()->route('staffLogin')->with('success', 'Password reset successfully.');
    }

    public function getRules(Request $request, $admin)
    {
        $rules = ['name' => 'required'];
        //        $rules['name'] = 'required|unique';
        //       $rules['email'] = 'required|unique';
        if ($admin) {
            if ($request->email && $admin->email != $request->email) {
                $rules['email'] = 'unique:users';
            }
        } else {
            $rules['email'] = 'unique:users';
        }
        return $rules;
    }

    public function showProfile()
    {
        $user = Customer::where('email', '=', auth()->user()->email)->first();
        $page_title  = 'Staff Profile';
        return view('site/staff/profile', compact('user', 'page_title'));
    }

    public function profileUpdate(Request $request, $id)
    {
        $user = Customer::where('id', '=', $id)->first();

        $user->firstname = $request->name;
        $user->email = $request->email;

        $rules = $this->getRules($request, $user);

        if ($request->p1 != '' || $request->p2 != '') {
            if ($request->p1 != $request->p2) {
                $rules['password'] = 'required|min:6';
            }
        }
        $this->validate($request, $rules);

        if ($request->p1 != '' && $request->p2 != '') {
            if ($request->p1 == $request->p2) {
                $user->password = bcrypt($request->p1);
            }
        }
        if ($request->hasFile('image')) {
            $rules['image'] = 'image|mimes:png,jpg,gif,jpeg';
        }

        //$user->password = bcrypt($request->p1);       


        $user->save();

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "staffs." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/staffs/'), $fileName);

            if ($user->image != 'photo.jpg' && is_file(public_path('uploads/site/staffs/' . $user->image))) {
                unlink(public_path('uploads/site/staffs/' . $user->image));
            }
            $user->avatar = $fileName;
        }

        $user->save();

        return redirect()->route('staff.profile.showprofile')->with('success', 'Profile update successfully');
    }
    
}
