<?php

namespace App\Http\Controllers\Site;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Routing\Route;
use App\Http\Controllers\Controller;

use App\Models\Enquiry;
use App\Models\Service;

use App\Models\Feedback;
use App\Models\User;
use App\Models\Quiz;
use App\Models\Lead;
use Validator;
use Auth;

class DashboardController extends Controller
{


    public function dashboard(){


        $enquiry = Enquiry::where('customer_id','=',Auth::user()->id)->count();
        $services = Service::where('customer_id','=',Auth::user()->id)->count();
        $completed = Service::where('customer_id','=',Auth::user()->id)->where('notification_status','=','Completed')->count();
        $rejected = Service::where('customer_id','=',Auth::user()->id)->where('notification_status','=','Rejected')->count();

        $quiz = Quiz::count();
        $feedback = Feedback::where('user_id','=',Auth::user()->id)->count();
        
        
        return view('site/user/dashboard',compact('enquiry','services','completed','rejected','quiz','feedback'));
    }
    public function LeadNotifier(){
        
    }
}
