<?php

namespace App\Http\Controllers\Site;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Routing\Route;
use App\Http\Controllers\Controller;
use App\Models\Customer;
use DB;
use Auth;

class CustomerLoginController extends Controller
{
   /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
         
    
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

   

       public function login()
    {
        return view('customer/login');
    }

    

       public function signup(Request $request)
    {

        return view('customer/register');
    }

       public function store(Request $request)
    {

        //dd($request);        
        $user = new Customer;
        $user->firstname = $request->name;
        $user->email = $request->email;
        $user->phone_one = $request->mobile;
       
           $rules = $this->getRules($request, $user);
         if ($request->password != '' || $request->password_confirmation != '') {            
            if ($request->password != $request->password_confirmation) {
                $rules['password'] = 'required|min:6|confirmed';

            }
        }

        
        $this->validate($request, $rules);


        if ($request->password != '' && $request->password_confirmation != '') {
            if ($request->password == $request->password_confirmation) {
                $user->password = bcrypt($request->password);
            }
        }


        $user->save();
        return redirect()->route('customerLogin')->with('success', 'saved');
    }

       public function checkLogin(Request $request)
    {

        //dd($request);

    $this->validate($request, [
           'email'   => 'required|email',
           'password'  => 'required|alphaNum|min:3'
     ]);

         $user_data = array(
                'email'  => $request->get('email'),
                'password' => $request->get('password')
                
         );

                  
        if(Auth::guard('customer')->attempt($user_data)) {           
          // dd($user_data);
            return redirect()->route('customer.profile.showprofile')->with('success', 'saved');
           }
          else
         {
          return back()->with('error', 'These credentials do not match our records.');
         }

}


    
 public function getRules(Request $request, $admin)
    {
        $rules = ['name' => 'required'];
//        $rules['name'] = 'required|unique';
        //       $rules['email'] = 'required|unique';
        if ($admin) {
            if ($request->email && $admin->email != $request->email) {
                $rules['email'] = 'unique:users';
            }
        } else {
            $rules['email'] = 'unique:users';
        }
        return $rules;
    }


     public function showProfile() {
        $user = Customer::where('email','=',auth()->user()->email)->first();       
        $page_title  = 'Customer Profile';
        return view('site/customer/profile', compact('user','page_title'));
        
    }


    public function profileUpdate(Request $request, $id) {        
        $user = Customer::where('id', '=', $id)->first();
               
        $user->firstname = $request->name;
        $user->email = $request->email;

        $rules = $this->getRules($request, $user);

        if ($request->p1 != '' || $request->p2 != '') {
            if ($request->p1 != $request->p2) {
                $rules['password'] = 'required|min:6';
            }
        }
        $this->validate($request, $rules);

        if ($request->p1 != '' && $request->p2 != '') {
            if ($request->p1 == $request->p2) {
                $user->password = bcrypt($request->p1);
            }
        }
        if ($request->hasFile('image')) {
            $rules['image'] = 'image|mimes:png,jpg,gif,jpeg';
        }
        
        //$user->password = bcrypt($request->p1);       

       
        $user->save();

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "_customer_$user->id." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/customers/'), $fileName);

            if ($user->image != 'photo.jpg' && is_file(public_path('uploads/site/customers/' . $user->image))) {
                unlink(public_path('uploads/site/customers/' . $user->image));
            }
            $user->avatar = $fileName;
        }

        $user->save();

        return redirect()->route('agent.customer.show')->with('success', 'Profile update successfully');

    }
}
