<?php



namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Helpers\UserHelper;
use App\Mail\SendMail;
use App\Models\User;
use App\Models\AssignUser;
use Validator;
use Image;



class UserController extends Controller

{    

    public function index(Request $request){     
     $page_title = 'Users';    
     $users = User::where('id','!=',1)->get();  
     // /dd($users);   
    return view('admin/users/index', compact('page_title', 'users'));    
   }


    public function create(Request $request){ 
                
       $page_title = 'Add User';   
       $users = UserHelper::users();
       $states = HeaderHelper::states();
       $departments = UserHelper::departments();
       $policyBranches = UserHelper::policyBranches();
       $groups = UserHelper::usersGroup();
       $northBranches = UserHelper::northBranches();
       $southBranches = UserHelper::southBranches();

      
       return view('admin/users/add', compact('page_title','states','users','departments','policyBranches','groups','northBranches','southBranches'));    
      }

     public function store(Request $request){
         
     //dd($request->all());
      /*$this->validate($request, [
      'password' => 'required|string|min:6|regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{6,}$/',         
     ]);*/ 

      $checkexistingUser = UserHelper::uniqueUserVerification($request->username, $request->email);
      
      if($checkexistingUser == 'true'){
        return redirect()->route('admin.users.create')->with('error', 'User already exist with this username or email. Please try another details.');
      }
      $User = new User;
      $User->user_role = $request->user_role;
      $User->user_group = $request->user_group;
      $User->clo_id = $request->clo_id;
      $User->username = $request->username;
      $User->password = Hash::make($request->password);
      $User->name = $request->firstname;
      $User->lastname = $request->lastname;
      $User->email = $request->email;
      $User->ies_branch_code = $request->sbu;
      
      $User->phone = $request->phone_one;
      $User->address = $request->address;
      
      $User->state = '';

      if($request->user_group == 1){
          $User->user_branch = $request->north_branch;
      }else if($request->user_group == 2){
          $User->user_branch = $request->south_branch;

      }


    
      $User->status = $request->get('status',0);

      $User->save();
      if($request->user_role == 2){
        $path = 'uploads/site/admin/'.$request->user_role;
      }elseif($request->user_role == 3){
         $path = 'uploads/site/staff/'.$request->user_role;
      }elseif($request->user_role == 4){
         $path = 'uploads/site/teamLead/'.$request->user_role;
      }elseif($request->user_role == 5){
         $path = 'uploads/site/supervisors/'.$request->user_role;
      }elseif($request->user_role == 6){
         $path = 'uploads/site/management/'.$request->user_role;
      }elseif($request->user_role == 7){
         $path = 'uploads/site/audit/'.$request->user_role;
      }elseif($request->user_role == 8){
         $path = 'uploads/site/customerservice/'.$request->user_role;
      }

      if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "user." . $image->getClientOriginalExtension();
            $image->move(public_path($path), $fileName);

            if ($User->image != 'photo.jpg' && is_file(public_path($path . $User->image))) {
                unlink(public_path($path . $User->image));
            }
             $User->avatar = $path .'/'.$fileName;
             $User->image = $path .'/'.$fileName;
             $User->save();
        }
       
     return redirect()->route('admin.users.show')->with('success', 'User Add Successfully.');

            
   }

     public function show($id) {
        $user = User::where('id', '=', $id)->first();
        $departments = UserHelper::departments();
        $users = UserHelper::users();
        $states = HeaderHelper::states();
        $policyBranches = UserHelper::policyBranches();
        $groups = UserHelper::usersGroup();
        $northBranches = UserHelper::northBranches();
        $southBranches = UserHelper::southBranches();
        return view('admin/users/edit', compact('user','states','users','departments','policyBranches','groups','northBranches','southBranches'));    
    }
    
   

     public function update(Request $request, $id) {  
    
      $User = User::where('id', '=', $id)->first();
      $User->user_role = $request->user_role;
      $User->user_group = $request->user_group;
      $User->clo_id = $request->clo_id;
      $User->username = $request->username;

       if (!empty($request->password)) {       
         
         $User->password = Hash::make($request->password);

          }else{
            $User->password = $request->oldpassword;
        }
     
      $User->name = $request->firstname;
      $User->lastname = $request->lastname;
      $User->email = $request->email;
      $User->ies_branch_code = $request->sbu;
      $User->phone = $request->phone_one;
      $User->address = $request->address;
      
      $User->state = '';

      if($request->user_group == 1){
          $User->user_branch = $request->north_branch;
      }else if($request->user_group == 2){
          $User->user_branch = $request->south_branch;

      }
      
      $User->status = $request->get('status',0);

      $User->save();
      if($request->user_role == 2){
        $path = 'uploads/site/admin/'.$request->user_role;
      }elseif($request->user_role == 3){
         $path = 'uploads/site/staff/'.$request->user_role;
      }elseif($request->user_role == 4){
         $path = 'uploads/site/teamLead/'.$request->user_role;
      }elseif($request->user_role == 5){
         $path = 'uploads/site/supervisors/'.$request->user_role;
      }elseif($request->user_role == 6){
         $path = 'uploads/site/management/'.$request->user_role;
      }elseif($request->user_role == 7){
         $path = 'uploads/site/audit/'.$request->user_role;
      }elseif($request->user_role == 8){
         $path = 'uploads/site/customerservice/'.$request->user_role;
      }

     
      
      if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "staff." . $image->getClientOriginalExtension();
            $image->move(public_path($path), $fileName);

            if ($User->image != 'photo.jpg' && is_file(public_path($path . $User->image))) {
                unlink(public_path($path . $User->image));
            }
            $User->avatar = $path .'/'.$fileName;
            $User->image = $path .'/'.$fileName;
            $User->save();
        }            

      

    return redirect()->route('admin.users.show')->with('success', 'User Update Successfully .');
    }

     public function passwordValidation(Request $request) {
        $rules = array(
          'password' => 'required|string|min:6|regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{6,}$/'
        );  

            $validation = Validator::make($request->all(), $rules);  
            if ($validation->fails())  {  
                return response()->json($validation->errors()->toArray());
            }
            else{
               
            }

    }
   

     public function destroy($id) {

        $u = User::find($id); 
        $u->delete();
        return redirect()->route('admin.users.show')->with('success', 'User Delete Successfully.');
    }

    public function userList($id) {
        $user = User::where('id', '=', $id)->first();        
        if($user->user_role == 4){
           $userLists = User::where('user_role', '=', 3)->get();
        }elseif($user->user_role == 5){
          $userLists = User::where('user_role', '=', 4)->get();
        }elseif($user->user_role == 6){
          $userLists = User::where('user_role', '=', 5)->get();
        }

       

        $assignedusers = AssignUser::select('assigned_users.id','assigned_users.user_id','assigned_users.assign_user_id','users.user_role','users.name','users.lastname','users.image','users.email','users.phone')
        ->join('users', 'users.id', '=', 'assigned_users.assign_user_id')
        ->where('assigned_users.user_id', '=', $id)
        ->get();
        //dd($assignedusers);
        
        return view('admin/users/users', compact('user','userLists','assignedusers'));    
    }

    public function assignToUser(Request $request, $id) {
      /*Check if already assign*/
     
      $existingUser = AssignUser::where('assign_user_id', '=', $request->user_id)->where('user_id', '=', $id)->exists();
   
       if($existingUser == 1){
        return redirect()->route('admin.users.list.show',$id)->with('error', 'You have already assigned this user');
       }
      
      foreach ($request['user_id'] as $key => $value) {
      //dd($value);
      $AssignUser = new AssignUser;
      $AssignUser->user_id = $id;
      $AssignUser->assign_user_id = $value;      
      $AssignUser->save();
      }
      
      return redirect()->route('admin.users.list.show',$id)->with('success', 'User Assigned Successfully.');
    }


     public function assignedUserDelete($id) {
        $u = AssignUser::where('id','=',$id)->first(); 
        $u->delete();
        return redirect()->route('admin.users.list.show',$u->user_id)->with('success', 'User Delete Successfully.');
    }

    
    public function exportCsv(Request $request){
      $fileName = 'users.csv'; 
      $foundflag = false;
      $array     = [];
      $i         = 0;   
   

       $users = User::where('id','!=',1)->get(); 

       $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('User Type', 'Name','Email','Mobile', 'Address', 'City','State','PostCode');

            $callback = function() use($users, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($users as $user) {

              if($user->user_role == 1){
                 $type = 'Super Admin';
              }else if($user->user_role == 2){
                  $type = 'Admin';
              }else if($user->user_role == 3){
                $type = 'BD Staff';
              }
               else if($user->user_role == 4){
                $type = 'Team Leads';
              }
               else if($user->user_role == 5){
                $type = 'Supervisors';
              }
               else if($user->user_role == 6){
                $type = 'Management';
              }
              else if($user->user_role == 7){
                $type = 'Audit';
              }
              else if($user->user_role == 8){
                $type = 'Customer-Service';
              }


                $row['User Type']        = $type;
                $row['Name']             = $user['firstname'].' '.$user['lastname'];
                $row['Email']            = $user['email'];
                $row['Mobile']           = $user['phone'];
                $row['Address']          = $user['address'];
                $row['City']             = $user['city'];
                $row['State']            = $user['phone'];
                $row['PostCode']         = $user['postcode'];
                
             
               
            fputcsv($file, array( $row['User Type'], $row['Name'],$row['Email'], $row['Mobile'], $row['Address'], $row['City'],$row['State'],$row['PostCode']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }
    

}

