<?php



namespace App\Http\Controllers\Admin\TeamLead;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\BulkExport;
use App\Imports\BulkImport;

use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\User;
use App\Models\Policy;
use App\Models\Sale;
use App\Models\AssignUser;
use Validator;
use Image;
use Auth;
use Carbon\Carbon;
use GuzzleHttp\Client;

class PolicyController extends Controller

{    

    public function renewals(Request $request){     

    $page_title = 'Policy Renewals';    
    
    $staffs = AssignUser::where('user_id','=',Auth::user()->id)
     ->join('users', 'assigned_users.assign_user_id', '=', 'users.id')
     ->select('assigned_users.*','users.clo_id')
    ->get(); 
    //dd($staffs);

    if($request->search == 'Search'){
    $client = new Client();
    $response = $client->request('POST', 'https://enterprise.veritaskapital.net/api/renewals',[
    'form_params' => [
        'effective_date' => $request->effective_date,
        'expiration_date' => $request->expiration_date,
        'sum_insured' => $request->premium,
        'insured_name' => $request->insured_name,
        'branch' => $request->branch,
        'agent' => $request->agency,
        'pol_num' => $request->pol_num,
        'pol_class' => $request->pol_class,
        'clo_id' => $request->clo_id,
        'clo_name' => $request->clo_name,
        'cover_start' => $request->cover_start,
        'cover_end' => $request->cover_end,
]]);
    $statusCode = $response->getStatusCode();
    $renewals = $response->getBody()->getContents();
    $renewals = json_decode($renewals);
    $effective_date = $request->effective_date;
    $expiration_date = $request->expiration_date;

    $foundflag = false;
    $array     = [];
    $i         = 0;
    foreach ($renewals->data as $renewal) {
        $insured_period = explode('To',$renewal->insured_period);
        $start_insured= $insured_period[0];
        $stop_insured = $insured_period[1];
        foreach ($staffs as $staff) {
        if($renewal->clo == $staff->clo_id){

             $foundflag = true;
             $array[$i]['customer_name'] = $renewal->customer_name;
             $array[$i]['policy_type'] = $renewal->policy_type;
             $array[$i]['clo_name'] = $renewal->clo_name;
             $array[$i]['policy_number'] = $renewal->policy_number;
             $array[$i]['sales_amount'] = number_format($renewal->sales_amount);
             $array[$i]['expiration_date'] = $renewal->expiration_date;
             $array[$i]['agency_name'] = $renewal->agency_name;
             $array[$i]['effective_date'] = $renewal->effective_date;
             $array[$i]['start_insured_period'] = $start_insured;
$array[$i]['stop_insured_period'] = $stop_insured;



        }
       }
        $i++;
    }

    $sales = $array;
    $effective_date = $request->effective_date;
    $expiration_date = $request->expiration_date;
    $premium = $request->premium;
    $insured_name = $request->insured_name;
    $branch = $request->branch;
    $agent = $request->agency;
    $pol_num = $request->pol_num;
    $pol_class = $request->pol_class;
    $clo_id = $request->clo_id;
    $clo_name = $request->clo_name;
    $cover_start = $request->cover_start;
    $cover_end = $request->cover_end;

    }else{

    $client = new Client();
    $response = $client->request('GET', 'https://enterprise.veritaskapital.net/api/renewals');
    $statusCode = $response->getStatusCode();
    $renewals = $response->getBody()->getContents();
    $renewals = json_decode($renewals);
    $effective_date = '';
    $expiration_date = '';

    $foundflag = false;
    $array     = [];
    $i         = 0;
    foreach ($renewals->data as $renewal) {
        $insured_period = explode('To',$renewal->insured_period);
        $start_insured= $insured_period[0];
        $stop_insured = $insured_period[1];
         foreach ($staffs as $staff) {
        if($renewal->clo == $staff->clo_id){

             $foundflag = true;
             $array[$i]['customer_name'] = $renewal->customer_name;
             $array[$i]['policy_type'] = $renewal->policy_type;
             $array[$i]['clo_name'] = $renewal->clo_name;
             $array[$i]['policy_number'] = $renewal->policy_number;
             $array[$i]['sales_amount'] = number_format($renewal->sales_amount);
             $array[$i]['expiration_date'] = $renewal->expiration_date;
             $array[$i]['agency_name'] = $renewal->agency_name;
             $array[$i]['effective_date'] = $renewal->effective_date;
             $array[$i]['start_insured_period'] = $start_insured;
$array[$i]['stop_insured_period'] = $stop_insured;



        }
       }
        $i++;
    }

    $sales = $array;
   $effective_date = '';
    $expiration_date = '';
    $premium = '';
    $insured_name = '';
    $branch = '';
    $agent = '';
    $pol_num = '';
    $pol_class = '';
    $clo_id = '';
    $clo_name = '';
    $cover_start = '';
    $cover_end = '';

    }
   
    
   $renewals = $array;

   return view('admin/teamleads/policy/index', compact('page_title', 'renewals','staffs','effective_date','expiration_date','premium','insured_name','branch','agent','pol_num','pol_class','clo_id','clo_name','cover_start','cover_end'));    
   }


  public function getPolicies($id){     
   

  }

  public function exportCsv(Request $request){
      $fileName = ''; 
      $foundflag = false;
      $array     = [];
      $renewals =[];
      $i         = 0;

    $staffs = AssignUser::where('user_id','=',Auth::user()->id)
        ->join('users', 'assigned_users.assign_user_id', '=', 'users.id')
        ->select('assigned_users.*','users.clo_id')
        ->get();   
      
 
    if($request->input('start_date')!==null && $request->input('stop_date')!==null){
        $fileName = 'renewalsbtw-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv'; 
        $client = new Client();
        $response = $client->request('POST', 'https://enterprise.veritaskapital.net/api/renewals',[
            'form_params' => [
                'effective_date' => $request->input('start_date'),
                'expiration_date' => $request->input('stop_date'),
              ]]);
        $statusCode = $response->getStatusCode();
        $renewals = $response->getBody()->getContents();
        $renewals = json_decode($renewals);
            
    }
    else{
        $fileName = 'renewals.csv'; 
        $client = new Client();
        $response = $client->request('GET', 'https://enterprise.veritaskapital.net/api/renewals');
        $statusCode = $response->getStatusCode();
        $renewals = $response->getBody()->getContents();
        $renewals = json_decode($renewals);

    }
      
    foreach ($renewals->data as $renewal) {
        $insured_period = explode('To',$renewal->insured_period);
            $start_insured= $insured_period[0];
            $stop_insured = $insured_period[1];
         foreach ($staffs as $staff) {
            if($renewal->clo == $staff->clo_id){

                $foundflag = true;
                $array[$i]['customer_name'] = $renewal->customer_name;
                $array[$i]['policy_type'] = $renewal->policy_type;
                $array[$i]['clo_name'] = $renewal->clo_name;
                $array[$i]['policy_number'] = $renewal->policy_number;
                $array[$i]['sales_amount'] = number_format($renewal->sales_amount);
                $array[$i]['expiration_date'] = $renewal->expiration_date;
                $array[$i]['agency_name'] = $renewal->agency_name;
                $array[$i]['effective_date'] = $renewal->effective_date;
                $array[$i]['start_insured_period'] = $start_insured;
                $array[$i]['stop_insured_period'] = $stop_insured;

            }
       }
        $i++;
    }

    
   
    
   $renewals = $array; 

   //dd($finalrenewals);
    
        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Purchased By', 'Policy Type','Clo Name','Policy Number', 'Policy Premium', 'Policy Expire','Agency','Effective Date','Start_Policy_Period', 'Stop_Policy_Period');

            $callback = function() use($renewals, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($renewals as $renewal) {
                $row['Purchased By']        = $renewal['customer_name'];
                $row['Policy Type']         = $renewal['policy_type'];
                $row['Clo Name']            = $renewal['clo_name'];
                $row['Policy Number']       = $renewal['policy_number'];
                $row['Policy Premium']      = $renewal['sales_amount'];
                $row['Policy Expire']       = $renewal['expiration_date'];
                $row['Agency']              = $renewal['agency_name'];
                $row['Effective Date']      = $renewal['effective_date'];
                $row['Start_Policy_Period']       = $renewal['start_insured_period'];
                $row['Stop_Policy_Period']       = $renewal['stop_insured_period'];
                
        fputcsv($file, array( $row['Purchased By'], $row['Policy Type'],$row['Clo Name'], $row['Policy Number'], $row['Policy Premium'],$row['Effective Date'], $row['Policy Expire'],$row['Agency'],$row['Start_Policy_Period'], $row['Stop_Policy_Period']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }
    
    

}

