<?php



namespace App\Http\Controllers\Admin\TeamLead;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Exports\BulkExport;
use App\Imports\BulkImport;
use Maatwebsite\Excel\Facades\Excel;

use App\Helpers\HeaderHelper;
use App\Helpers\UserHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\Insurance;
use App\Models\User;
use App\Models\Lead;
use App\Models\AssignUser;
use Validator;
use Image;
use Auth;


class LeadController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Leads'; 
      $start_date = $request->start_date;
      $stop_date = $request->stop_date;   
    $leads = [];
    $assigned_by = $request->assigned_by;
    if($request->search == 'Search'){      
      
      $assignedStaffsLists = UserHelper::getAssignStaffsUserList(Auth::user()->id);   
     
      if(is_object ($assignedStaffsLists)){
        if(isset($request->assigned_by)){
          foreach ($assignedStaffsLists as $key => $value) {

            $leads = Lead::where('assigned_by_user_id','=',Auth::user()->id)
                   // ->orWhere('assigned_by_user_id','=',$value->assign_user_id)
                    ->where('leads.user_role','=',3)
                    ->whereBetween('leads.created_at',[$start_date, $stop_date])
                    ->where('assigned_by_user_name','like',"%{$request->assigned_by}%")
                  //->orWhere('leads.user_role','=',40)
                    ->join('users', 'leads.user_id', '=', 'users.id')
                    ->select('leads.*','users.name as staffname')
                    ->get(); 
           
            }
        }
        else{
          foreach ($assignedStaffsLists as $key => $value) {

            $leads = Lead::where('assigned_by_user_id','=',Auth::user()->id)
                    ->orWhere('assigned_by_user_id','=',$value->assign_user_id)
                    ->where('leads.user_role','=',3)
                    ->whereBetween('leads.created_at',[$start_date, $stop_date])
                  //->orWhere('leads.user_role','=',40)
                    ->join('users', 'leads.user_id', '=', 'users.id')
                    ->select('leads.*','users.name as staffname')
                    ->get(); 
           
            }
        }
      

      }      

    }else{

      $teamLeadLists =  UserHelper::getAssignStaffsUserList(Auth::user()->id);     
      $ids = [0];
      foreach ($teamLeadLists as $key => $value) { 
        $ids[] = $value['assign_user_id'];
      }

      $leads = Lead::whereIn('assigned_by_user_id',array($ids,Auth::user()->id))
                    ->join('users', 'leads.user_id', '=', 'users.id')
                    ->select('leads.*','users.name as staffname')
                    ->get();
    }
    //   $assignedStaffsLists = UserHelper::getAssignStaffsUserList(Auth::user()->id);
      
    //   if(is_object ($assignedStaffsLists)){
 
    //     foreach ($assignedStaffsLists as $key => $value) {

    //       $leads = Lead::where('assigned_by_user_id','=',Auth::user()->id)
    //       ->orhere('user_id', '=', Auth::user()->id)
    //           ->orWhere('assigned_by_user_id','=',$value->assign_user_id)
    //           ->where('leads.user_role','=',3)
    //         ->orWhere('leads.user_role','=',40)
    //            ->join('users', 'leads.user_id', '=', 'users.id')
    //            ->select('leads.*','users.name as staffname')
    //           ->get(); 
        
    //       }

    //     }
        
    //   }
   

    return view('admin/teamleads/index', compact('page_title', 'leads','start_date','stop_date','assigned_by'));  
     //dd($leads);  
   }

    public function assignedLeads(Request $request){     
    $page_title = 'Assigned Leads';       
    Lead::where('user_id','=',Auth::user()->id)->where('created_at','>=',date('Y-m-d'))->update(['notify_status'=>false]);

    $assigned_by = $request->assigned_by;
    $clo_name = $request->clo_name;
    $start_date = $request->start_date;
    $stop_date = $request->stop_date;
    
    if($request->search == 'Search'){
      if(isset($start_date) && isset($stop_date)){
        $leads = Lead::where('user_id','=',Auth::user()->id)
                      ->whereBetween('leads.created_at',[$start_date, $stop_date])
                      ->get(); 
      }
      if(isset($request->assigned_by)){
        $leads = Lead::where('user_id','=',Auth::user()->id)
                      ->whereBetween('leads.created_at',[$start_date, $stop_date])
                      ->where('assigned_by_user_name','like',"%{$request->assigned_by}%")
                      ->get(); 
      }
    }
    else{
      $leads = Lead::where('user_id','=',Auth::user()->id)
                    ->where('assigned_by_user_id', '=', Auth::user()->id)
                ->get(); 
    }
    
    return view('admin/teamleads/leads', compact('page_title', 'leads','assigned_by','start_date','stop_date')); 
    dd($leads);   
   }




    public function create(Request $request){                 
       $page_title = 'Add Leads';
       $sources = HeaderHelper::leadSource();
       $states = HeaderHelper::states();
       $staffs = AssignUser::where('user_id', '=', Auth::user()->id)
       ->join('users','assigned_users.assign_user_id','=','users.id')
       ->select('assigned_users.*','users.name','users.lastname')
       ->get()->toArray();
       $teamlead = User::where('id', '=', Auth::user()->id)->get()->toArray();
      
       $staff = ['assign_user_id'=> Auth::user()->id,'name' => $teamlead[0]['name'],'lastname'=>$teamlead[0]['lastname']]; 
      //  dd($staffs,$staff);
       $insurances = Insurance::get();
        
       return view('admin/teamleads/add', compact('page_title','states','staff','staffs','sources','insurances'));    
      }

     public function store(Request $request){ 
      
      $this->validate($request,[
            'contact_no' => 'required|digits:11|numeric',
            
      ]);
      $Lead = new Lead;
      $Lead->user_id = $request->user_role;
      $Lead->type = 'staff';
      $Lead->assigned_by_user_id = Auth::user()->id;
      $Lead->user_role = User::where('id','=',$request->user_role)->pluck('user_role')->first();
      $Lead->assigned_by_user_name = Auth::user()->name.' '.Auth::user()->lastname;
      $Lead->firstname = $request->firstname;
      $Lead->lastname = $request->lastname;
      $Lead->email = $request->email;

      $Lead->contact_no = $request->contact_no;
     
      $Lead->address = $request->address;
      $Lead->city = $request->city;
      $Lead->state = $request->state;
      /*$Lead->post_code = $request->postcode;*/

      $Lead->lead_source = $request->lead_source;
      $Lead->lead_description = $request->lead_description;
      $Lead->lead_type = $request->lead_type;
      $Lead->orgnisation_type = $request->orgnisation_type;
      if($request->orgnisation_type  ==  'Company'){
        $Lead->nature_of_organisation = $request->nature_of_org;
      }else{
         $Lead->nature_of_organisation = $request->nature_of_org_new;
      }
     
      $Lead->referred_by = $request->referred_by;
      $Lead->save();

      /*if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "lead." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/teamLead/leads'), $fileName);

            if ($Lead->image != 'photo.jpg' && is_file(public_path('uploads/site/teamLead/leads' . $Lead->image))) {
                unlink(public_path('uploads/site/teamLead/leads' . $Lead->image));
            }
            $Lead->image = 'uploads/site/teamLead/leads'.'/'.$fileName;
            $Lead->save();
        }*/

       
      return redirect()->route('teamLead.leads.show')->with('success', 'Lead Create Successfully.');

            
   }

     public function show($id) {
        $lead = Lead::where('id', '=', $id)->first(); 
        $sources = HeaderHelper::leadSource();
        $states = HeaderHelper::states();    
        $staffs = AssignUser::where('user_id', '=', Auth::user()->id)
       ->join('users','assigned_users.assign_user_id','=','users.id')
       ->select('assigned_users.*','users.name','users.lastname')
       ->get()->toArray();
      
       $staffs[] = ['assign_user_id'=> Auth::user()->id,'name' => 'Himself','lastname'=>'']; 
        $insurances = Insurance::get();
        return view('admin/teamleads/edit', compact('lead','states','staffs','sources','insurances'));    
    }

     public function update(Request $request, $id) {
    // /dd($request);
      $this->validate($request,[
           'contact_no' => 'required|digits:11|numeric',
            
      ]);  
      $Lead = Lead::where('id', '=', $id)->first();    

      $Lead->user_id = $request->user_role;
      $Lead->type = 'staff';
      $Lead->assigned_by_user_id = Auth::user()->id;
      $Lead->user_role = User::where('id','=',$request->user_role)->pluck('user_role')->first();
      $Lead->assigned_by_user_name = Auth::user()->name.' '.Auth::user()->lastname;

      $Lead->firstname = $request->firstname;
      $Lead->lastname = $request->lastname;
      $Lead->email = $request->email;
     
      
      $Lead->contact_no = $request->contact_no;
      $Lead->address = $request->address;

      $Lead->city = $request->city;
      $Lead->state = $request->state;
      /*$Lead->post_code = $request->postcode;*/

      $Lead->lead_source = $request->lead_source;
      $Lead->lead_description = $request->lead_description;
      $Lead->lead_type = $request->lead_type;
      
      $Lead->orgnisation_type = $request->orgnisation_type;
      if($request->orgnisation_type  ==  'Company'){
        $Lead->nature_of_organisation = $request->nature_of_org;
      }else{
         $Lead->nature_of_organisation = $request->nature_of_org_new;
      }
      $Lead->referred_by = $request->referred_by;

      $Lead->save();
      /*if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "lead." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/teamLead/leads'), $fileName);

            if ($Lead->image != 'photo.jpg' && is_file(public_path('uploads/site/teamLead/leads' . $Lead->image))) {
                unlink(public_path('uploads/site/teamLead/leads' . $Lead->image));
            }
            $Lead->image = 'uploads/site/teamLead/leads'.'/'.$fileName;
            $Lead->save();
        }  */          

      

    return redirect()->route('teamLead.leads.show')->with('success', 'Lead Update Successfully.');
    }

  

     public function destroy(Request $request) {
       $id = $request->input('id');
        $c = Lead::find($id); 
        $c->delete();
        return redirect()->route('teamLead.leads.show')->with('success', 'Lead Delete Successfully.');
    }

     public function details($id) {
        $lead = Lead::where('id', '=', $id)->first(); 
        $insurances = Insurance::get();
        //dd($insurances);          
        return view('admin/teamleads/detail', compact('lead','insurances'));  
    }

   public function importExportView(Request $request){                 
       $page_title = 'Add Import';
       return view('admin/teamleads/import', compact('page_title'));    
      }
    
    public function import(Request $request)   {
      $this->validate($request, [
         'file'=> 'required|mimes:xls,xlsx'
     ]);

      $path = $request->file('file')->getRealPath();
      Excel::import(new BulkImport,request()->file('file'));
      return redirect()->route('teamLead.leads.show')->with('success', 'Excel Data Imported successfully.');

    }


    public function exportCSV(Request $request){
      $fileName = ''; 
      $foundflag = false;
      $leads = [];
      $i         = 0;   
   
      
      $assignedStaffsLists = UserHelper::getAssignStaffsUserList(Auth::user()->id);
      
      if(is_object ($assignedStaffsLists)){
        if($request->input('start_date')!==null && $request->input('stop_date')!==null){
          $fileName = 'teamleadbtw-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv'; 
          foreach ($assignedStaffsLists as $key => $value) {
              $leads = Lead::where('assigned_by_user_id','=',Auth::user()->id)
                  ->orWhere('assigned_by_user_id','=',$value->assign_user_id)
                  ->whereBetween('leads.created_at',[$request->input('start_date'),$request->input('stop_date')])
                  ->where('leads.user_role','=',3)
                //->orWhere('leads.user_role','=',40)
                  ->join('users', 'leads.user_id', '=', 'users.id')
                  ->select('leads.*','users.name as staffname')
                  ->get(); 
            }
          }
        else{
          $fileName = 'teamlead.csv'; 
          foreach ($assignedStaffsLists as $key => $value) {
            $leads = Lead::where('assigned_by_user_id','=',Auth::user()->id)
                ->orWhere('assigned_by_user_id','=',$value->assign_user_id)
                ->where('leads.user_role','=',3)
              //->orWhere('leads.user_role','=',40)
                ->join('users', 'leads.user_id', '=', 'users.id')
                ->select('leads.*','users.name as staffname')
                ->get(); 
          }
        }
        }
    
      
       $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Assigned By', 'Name', 'Company','Company/Lead Type','Status');

            $callback = function() use($leads, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($leads as $lead) {
                
                $row['Assigned By']          = $lead->staffname;
                $row['Name']                 = $lead->firstname.' '.$lead->lastname;
                $row['Company']              = $lead->nature_of_organisation;
                $row['Company/Lead Type']    = $lead->lead_type;
                $row['Status']               = $lead->status;
                
                
            fputcsv($file, array( $row['Assigned By'], $row['Name'], $row['Company'], $row['Company/Lead Type'], $row['Status']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }

    

}

