<?php



namespace App\Http\Controllers\Admin\Supervisiors;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Helpers\EmailHelper;
use App\Helpers\UserHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\User;
use App\Models\Lead;
use App\Models\Insurance;
use App\Models\Opportunity;
use App\Models\Sale;
use App\Models\Country;
use App\Models\Agency;
use App\Models\AssignUser;
use Validator;
use Image;
use Auth;
use GuzzleHttp\Client;

class SaleController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Sales';    
    $year = date('Y');
        $startDate = $year . '-01-01';
        $endDate = $year . '-12-31';

        $result = DB::connection('IES_DB')->select(
            "
                SELECT
                SUM(a.tgross) AS total_current_premium,
                g.itemdesc AS sbu_label,
                g.itemclass AS sbu
                FROM
                    nlfaccounts a
                INNER JOIN
                    nlfpolmain b ON a.polnum = b.polnum
                INNER JOIN
                    generalinfo g
                    ON g.itemclass = b.sbu
                    AND (
                        g.itemclass IN (
                            '00022','00012','00011','00014','00013','00023','00016','00015',
                            '00020','00019','00021','00018','00017'
                        )
                        AND g.itemsub IN ('00006', '00007')
                        AND g.rfvalue = ''
                    )
                INNER JOIN
                    nlfagency c ON a.account = c.code
                INNER JOIN
                    nlfbranches d ON b.branch = d.code
                INNER JOIN
                    nlfclients f ON a.client = f.clientno
                INNER JOIN
                    unitykap_iesonlinehmrs.hmrs_persdet e ON a.clo = e.staffid
                WHERE
                    a.trncode NOT IN ('0040', '0041')
                    AND a.efcdate BETWEEN ? AND ?
                GROUP BY
                    g.itemdesc, g.itemclass
                ORDER BY
                    total_current_premium DESC;

            ",
            [$startDate, $endDate]
        );
        
        //dd($result);

    return view('admin/supervisiors/sales/index', compact('page_title', 'result'));    
   }
   
   
    /*public function index_old(Request $request){     
    $page_title = 'Sales';    
    if($request->search == 'Search'){

      $teamLeads = AssignUser::where('user_id','=',Auth::user()->id)
     ->join('users', 'assigned_users.assign_user_id', '=', 'users.id')
     ->select('assigned_users.*','users.clo_id')
    ->get();

    
    foreach ($teamLeads as $key => $team) {
      $teamLeadsIDS[] =  $team->assign_user_id;
    }
  
   
     $staffs =  self::getStaffsList($teamLeadsIDS);  
     $users = array_merge($teamLeads->toArray(), $staffs->toArray());

    $client = new Client();
    $response = $client->request('POST', 'https://enterprise.veritaskapital.net/api/sales',[
    'form_params' => [
        'effective_date' => $request->effective_date,
        'expiration_date' => $request->expiration_date,
        'sum_insured' => $request->premium,
        'insured_name' => $request->insured_name,
        'branch' => $request->branch,
        'agent' => $request->agency,
        'pol_num' => $request->pol_num,
        'pol_class' => $request->pol_class,
        'clo_id' => $request->clo_id,
        'clo_name' => $request->clo_name,
        'cover_start' => $request->cover_start,
        'cover_end' => $request->cover_end,
]]);
    $statusCode = $response->getStatusCode();
    $sales = $response->getBody()->getContents();
    $sales = json_decode($sales);

    $foundflag = false;
    $array     = [];
    $i         = 0;
    foreach ($sales->data as $sale) {
         foreach ($staffs as $staff) {
        if($sale->clo == $staff->clo_id){

             $foundflag = true;
             $array[$i]['clo'] = $sale->clo;
             $array[$i]['customer_name'] = $sale->customer_name;
             $array[$i]['clo_name'] = $sale->clo_name;
             $array[$i]['product_class'] = $sale->product_class;
             $array[$i]['sales_amount'] = number_format($sale->sales_amount);
             $array[$i]['policy_number'] = $sale->policy_number;
             $array[$i]['agency_name'] = $sale->agency_name;
             $array[$i]['effective_date'] = $sale->effective_date;
             $array[$i]['expiration_date'] = $sale->expiration_date;



        }
       }
        $i++;
    }

    $sales = $array;
    $effective_date = $request->effective_date;
    $expiration_date = $request->expiration_date;
    $premium = $request->premium;
    $insured_name = $request->insured_name;
    $branch = $request->branch;
    $agent = $request->agency;
    $pol_num = $request->pol_num;
    $pol_class = $request->pol_class;
    $clo_id = $request->clo_id;
    $clo_name = $request->clo_name;
    $cover_start = $request->cover_start;
    $cover_end = $request->cover_end;

    }else{

      $teamLeads = AssignUser::where('user_id','=',Auth::user()->id)
     ->join('users', 'assigned_users.assign_user_id', '=', 'users.id')
     ->select('assigned_users.*','users.clo_id')
    ->get();

    
    foreach ($teamLeads as $key => $team) {
      $teamLeadsIDS[] =  $team->assign_user_id;
    }
  
   
     $staffs =  self::getStaffsList($teamLeadsIDS);  
     $users = array_merge($teamLeads->toArray(), $staffs->toArray());



    $client = new Client();
    $response = $client->request('GET', 'https://enterprise.veritaskapital.net/api/sales');
    $statusCode = $response->getStatusCode();
    $sales = $response->getBody()->getContents();
    $sales = json_decode($sales);
    $effective_date = '';
    $expiration_date = '';

    $foundflag=false;
    $array = [];
      $i = 0;
    foreach ($sales->data as $sale) {
        foreach ($users as $user) {
        if($sale->clo == $user['clo_id']){

             $foundflag = true;
             $array[$i]['clo_name'] = $sale->clo_name;
             $array[$i]['customer_name'] = $sale->customer_name;
             $array[$i]['product_class'] = $sale->product_class;
             $array[$i]['sales_amount'] = number_format($sale->sales_amount);
             $array[$i]['policy_number'] = $sale->policy_number;
             $array[$i]['agency_name'] = $sale->agency_name;
             $array[$i]['effective_date'] = $sale->effective_date;
             $array[$i]['expiration_date'] = $sale->expiration_date;



        }
       }
        $i++;
    }

    
   
    
   $sales = $array;
   $effective_date = '';
    $expiration_date = '';
    $premium = '';
    $insured_name = '';
    $branch = '';
    $agent = '';
    $pol_num = '';
    $pol_class = '';
    $clo_id = '';
    $clo_name = '';
    $cover_start = '';
    $cover_end = '';


    }

    



    return view('admin/supervisiors/sales/index', compact('page_title', 'sales','effective_date','expiration_date','premium','insured_name','branch','agent','pol_num','pol_class','clo_id','clo_name','cover_start','cover_end'));    
   }*/
   
   public function getSbuPolicies($id){      
    $page_title = 'Sales';    
    // If $year is not provided, default to the current year
        $year = date('Y');
        $startDate = $year . '-01-01';
        $endDate = $year . '-12-31';

        $sbu_name = $result = DB::connection('IES_DB')->select(
            "
            SELECT
                itemdesc FROM generalinfo WHERE itemclass = ? AND itemsub IN ('00006', '00007')
                        AND rfvalue = ''
                ;

            ",
            [$id]
        );

        //dd($sbu_name);

        $result = DB::connection('IES_DB')->select(
            "
                SELECT
                a.tgross,
                a.polnum as policy_number,a.dcnumb, b.insured, c.name as agent, a.client, c.code as agency_code, a.efcdate,  b.effdate,  b.enddate, a.tgross as sales_amount, b.curprem as PolicyAmt,
                    b.sumass as sum_insured, a.clo, concat(e.surname,' ',e.othnames) as clo_name, a.branch, d.name as branch_name, a.insurprd as insured_period, f.clientno, f.insured,a.entdate as entry_date,b.staffid as capturedby,
                g.itemdesc AS sbu_label,
                g.itemclass AS sbu,
                (select itemdesc from generalinfo where itemclass = a.polcls and itemid = '1') as itemdesc
                FROM
                    nlfaccounts a
                INNER JOIN
                    nlfpolmain b ON a.polnum = b.polnum
                INNER JOIN
                    generalinfo g
                    ON g.itemclass = b.sbu
                    AND (
                        g.itemclass IN (
                            '00022','00012','00011','00014','00013','00023','00016','00015',
                            '00020','00019','00021','00018','00017'
                        )
                        AND g.itemsub IN ('00006', '00007')
                        AND g.rfvalue = ''
                    )
                INNER JOIN
                    nlfagency c ON a.account = c.code
                INNER JOIN
                    nlfbranches d ON b.branch = d.code
                INNER JOIN
                    nlfclients f ON a.client = f.clientno
                INNER JOIN
                    unitykap_iesonlinehmrs.hmrs_persdet e ON a.clo = e.staffid
                WHERE
                    a.trncode NOT IN ('0040', '0041')
                    AND b.sbu = ?
                    AND a.efcdate BETWEEN ? AND ?
                ORDER BY
                    b.enddate DESC;

            ",
            [$id, $startDate, $endDate]
        );
        
    //dd($result);
    return view('admin/supervisiors/sales/viewsbus', compact('page_title', 'result', 'sbu_name'));    
   }


    public function getStaffsList($teamIDs){ 
     
      return AssignUser::whereIn('user_id',$teamIDs)
      ->join('users', 'assigned_users.assign_user_id', '=', 'users.id')
     ->select('assigned_users.*','users.clo_id')
      ->get(); 

    }



    public function create(Request $request,$id){ 
    $page_title = 'Convert To Sales'; 
    $sale = Sale::where('id', '=', $id)->first();
    $terms = UserHelper::daysInyears();
    $currencies = UserHelper::currency();
    
    $policyClasses = UserHelper::policyClasses();
    $policyBranches = UserHelper::policyBranches();
    $occupationalExposure = UserHelper::occupationalExposure();
    $businessLocations = UserHelper::businessLocations();
    $countries = Country::get();
    $agencyCategories = Agency::groupBy('agency_category_name')->get();

    //dd($sale);
     
    return view('admin/supervisiors/sales/add', compact('page_title','sale','id','terms','currencies','policyClasses','policyBranches','countries','occupationalExposure','businessLocations','agencyCategories'));            
        
    }

    public function store(Request $request){ 
      //dd($request);
      $Sale = Sale::where('id', '=', $request->id)->first();
      $Sale->user_id = $request->user_id;
      $Sale->lead_id = $request->lead_id;
      /*$Sale->insurance_id = $request->insurance_id;*/
      $Sale->insurance_no = $request->insurance_no;
      $Sale->client_code = $request->client_code;
      $Sale->agency_category_id = $request->agency_category_id;      
      $Sale->agency = $request->agency;      
      $Sale->insurance_class = $request->insurance_class;
      $Sale->insurance_type = $request->insurance_type;
      $Sale->business_type = $request->business_type;
      $Sale->insurance_group = $request->insurance_group;
      $Sale->reference = $request->reference;
      $Sale->currency = $request->currency;
      $Sale->rate = $request->rate;
      $Sale->issuance_date = $request->issuance_date;
      $Sale->term = $request->term;
      $Sale->cover_period_from = $request->cover_period_from;
      $Sale->cover_period_to = $request->cover_period_to;
      /*$Sale->limit_of_exposure = $request->limit_of_exposure;*/
      $Sale->insurance_branch = $request->insurance_branch;
      $Sale->business_location = $request->business_location;
      $Sale->geographical_cover = $request->geographical_cover;
      $Sale->occupational_exposure = $request->occupational_exposure;
      $Sale->insurance_status = $request->insurance_status;
      $Sale->save();

      if($Sale->insurance_status == 'Sale' || $Sale->insurance_status == 'Progress'){
        $account = EmailHelper::createAccount($Sale);
        EmailHelper::leadConvertToSale($request->lead_id);
    }

      $email = EmailHelper::sendEmailToUser($request);
      if($email == true){
        $Sale->email = $request->email;
        $Sale->email_sent = 'Yes';
        $Sale->save();
      

      }
      
      return redirect()->route('supervisiors.crm.sales.show')->with('success', 'Lead Convert to Sale Successfully.');  
   }


    
    public function details($id){      
    $page_title = 'Sales';    
    $sale = Sale::where('sales.id','=',$id)
    ->join('users', 'users.id', '=', 'sales.user_id')
    ->select('sales.*','users.name as staffname')
    ->first();
    //dd($sale);
    return view('admin/supervisiors/sales/detail', compact('page_title', 'sale'));    
   }

    public function exportCsv1(Request $request){
      $fileName = '';
      $sales = [];
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
        $fileName = 'CRMSalesbtw-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv';
          $sales =  Sale::where('sales.assigned_by_user_id','=',Auth::user()->id)
            ->whereBetween('sales.created_at',[$request->input('start_date'),$request->input('stop_date')])
            ->join('users', 'users.id', '=', 'sales.user_id')
            ->get();
      }
      else{
        $fileName = 'CRMSales.csv';
        $sales =  Sale::where('sales.assigned_by_user_id','=',Auth::user()->id)
        ->join('users', 'users.id', '=', 'sales.user_id')
        ->get();
      }
      

   
        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

        $columns = array('Customer', 'Policy', 'Premium', 'Agency', 'Currency','Rate','Term','Cover From','Cover To','Policy Branch');

            $callback = function() use($sales, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($sales as $sale) {
                $row['Customer']   = $sale->name;
                $row['Policy']     = $sale->insurance_name;
                $row['Premium']    = $sale->price;
                $row['Agency']     = $sale->agency;
                $row['Currency']   = $sale->currency;
                $row['Rate']       = $sale->rate;
                $row['Cover From'] = $sale->cover_period_from;
                $row['Cover To']   = $sale->cover_period_to;
                $row['Policy Branch']  = $sale->insurance_branch;

                fputcsv($file, array($row['Customer'], $row['Policy'], $row['Premium'], $row['Agency'], $row['Currency'], $row['Rate'], $row['Cover From'], $row['Cover To'], $row['Policy Branch']));
            }

            fclose($file);
        };        
        
        return response()->stream($callback, 200, $headers);
    }

    public function exportCsv(Request $request){
      $fileName = ''; 
      $foundflag = false;
      $array     = [];
      $sales = [];
      $i         = 0;   
      $teamLeadsIDS = [];
      
    $teamLeads = AssignUser::where('user_id','=',Auth::user()->id)
     ->join('users', 'assigned_users.assign_user_id', '=', 'users.id')
     ->select('assigned_users.*','users.clo_id')
    ->get();

    
    foreach ($teamLeads as $key => $team) {
      $teamLeadsIDS[] =  $team->assign_user_id;
    }
  
   
     $staffs =  self::getStaffsList($teamLeadsIDS);  
     $users = array_merge($teamLeads->toArray(), $staffs->toArray());


     if($request->input('start_date')!==null && $request->input('stop_date')!==null){
        $fileName = 'salesbtw-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv'; 
        $client = new Client();
        $response = $client->request('POST', 'https://enterprise.veritaskapital.net/api/sales',[
          'form_params' => [
              'effective_date' => $request->input('start_date'),
              'expiration_date' => $request->input('stop_date'),
            ]]);
        $statusCode = $response->getStatusCode();
        $sales = $response->getBody()->getContents();
        $sales = json_decode($sales);
      }
      else{
        $fileName = 'sales.csv'; 
        $client = new Client();
          $response = $client->request('GET', 'https://enterprise.veritaskapital.net/api/sales');
          $statusCode = $response->getStatusCode();
          $sales = $response->getBody()->getContents();
          $sales = json_decode($sales);
      }
    
    foreach ($sales->data as $sale) {
        foreach ($users as $user) {
        if($sale->clo == $user['clo_id']){

             $foundflag = true;
             $array[$i]['clo_name'] = $sale->clo_name;
             $array[$i]['customer_name'] = $sale->customer_name;
             $array[$i]['product_class'] = $sale->product_class;
             $array[$i]['sales_amount'] = number_format($sale->sales_amount);
             $array[$i]['policy_number'] = $sale->policy_number;
             $array[$i]['agency_name'] = $sale->agency_name;
             $array[$i]['effective_date'] = $sale->effective_date;
             $array[$i]['expiration_date'] = $sale->expiration_date;



        }
       }
        $i++;
    }

    
   
    
   $sales = $array;
   
    
        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Staff Name', 'Insured Name','Product','Policy Premium', 'Policy Number','Agency','Effective Date','Policy Expire');

            $callback = function() use($sales, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($sales as $sale) {
             
                $row['Staff Name']           = $sale['clo_name'];
                $row['Insured Name']         = $sale['customer_name'];
                $row['Product']              = $sale['product_class'];
                $row['Policy Premium']       = $sale['sales_amount'];
                $row['Policy Number']        = $sale['policy_number'];
                $row['Agency']               = $sale['agency_name'];
                $row['Effective Date']       = $sale['effective_date'];
                $row['Policy Expire']        = $sale['expiration_date'];
                
             
               
            fputcsv($file, array( $row['Staff Name'], $row['Insured Name'],$row['Product'], $row['Policy Number'], $row['Policy Premium'], $row['Agency'],$row['Effective Date'],$row['Policy Expire']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }
    
    public function crmsales(Request $request){
      $page_title = "Sales Conversion";
      $insured_name = $request->insured_name;
      $pol_class = $request->pol_class;
      $clo_name = $request->clo_name;
      $agency = $request->agency;
      $branch = $request->branch;
      $effective_date = $request->effective_date;
      $expiration_date = $request->expiration_date;
      if($request->search == 'Search'){
        if(isset($request->branch)){
          $sales= Sale::join('users','users.id','=','sales.user_id')
          ->select('sales.*','users.clo_id', 'users.name', 'sales.created_at as createdAt')
                   ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                   ->where('sales.insurance_branch',$request->branch)->get();
        }
        elseif(isset($request->agency)){
          $sales= Sale::join('users','users.id','=','sales.user_id')
          ->select('sales.*','users.clo_id', 'users.name', 'sales.created_at as createdAt')
                   ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                   ->where('sales.agency','LIKE',"%{$request->agency}%")->get();
        }
        elseif(isset($request->clo_name)){
          $sales= Sale::join('users','users.id','=','sales.user_id')
          ->select('sales.*','users.clo_id', 'users.name', 'sales.created_at as createdAt')
                   ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                   ->where(DB::raw('concat(users.firstname," ",users.lastname)'),'LIKE',"%{$request->clo_name}%")->get();
        }
        elseif(isset($request->pol_class)){
          $sales= Sale::join('users','users.id','=','sales.user_id')
          ->select('sales.*','users.clo_id', 'users.name', 'sales.created_at as createdAt')
                   ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                   ->where('sales.insurance_name','LIKE',"%{$request->pol_class}%")->get();
        }
        elseif(isset($request->insured_name)){
          $sales= Sale::join('users','users.id','=','sales.user_id')
                    ->join('leads','leads.user_id','=','users.id')
                    ->select('sales.*','users.clo_id', 'users.name', 'sales.created_at as createdAt')
                   ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                   ->where(DB::raw('concat(leads.firstname," ",leads.lastname)'),'LIKE',"%{$request->insured_name}%")->get();
        }
        else{
          $sales= Sale::join('users','users.id','=','sales.user_id')
          ->select('sales.*','users.clo_id', 'users.name', 'sales.created_at as createdAt')
                   ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])->get();
        }
      }
      else{
          $sales= Sale::join('users','users.id','=','sales.user_id')->select('sales.*','users.clo_id', 'users.name', 'sales.created_at as createdAt')->get();

      }
 
       return view('admin/supervisiors/sales/crm',compact('page_title','sales','effective_date','expiration_date','insured_name','pol_class','clo_name','agency','branch'));
    }
    

}

