<?php



namespace App\Http\Controllers\Admin\Supervisiors;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Exports\BulkExport;
use App\Imports\BulkImport;
use Maatwebsite\Excel\Facades\Excel;

use App\Helpers\HeaderHelper;
use App\Helpers\UserHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\Insurance;
use App\Models\User;
use App\Models\Lead;
use App\Models\AssignUser;
use Validator;
use Image;
use Auth;


class LeadController extends Controller

{    

    public function index(Request $request)
    {     
        $page_title = 'Leads'; 
        $start_date = $request->start_date;
        $stop_date = $request->stop_date; 
        $assigned_by = $request->assigned_by;
    
        $teamLeadLists = UserHelper::getAssignedTeamLeadUsersList(Auth::user()->id);     
        $ids = [0]; // Start with a default ID (if required)
        foreach ($teamLeadLists as $value) { 
            $ids[] = $value['assign_user_id'];
        }
    
        // Add the current user's ID to the list
        $ids[] = Auth::user()->id;
    
        $leadsQuery = Lead::whereIn('assigned_by_user_id', $ids)
            ->join('users', 'leads.user_id', '=', 'users.id')
            ->select('leads.*', 'users.name as staffname', 'users.ies_branch_code as ies_branch_code');
    
        if ($request->search == 'Search') {
            $leadsQuery->whereBetween('leads.created_at', [$start_date, $stop_date]);
    
            if ($request->assigned_by) {
                $leadsQuery->where('assigned_by_user_name', 'like', "%{$request->assigned_by}%");
            }
        }
    
        $leads = $leadsQuery->get();
    
        return view('admin/supervisiors/index', compact('page_title', 'leads', 'start_date', 'stop_date', 'assigned_by'));
    }



    public function create(Request $request){ 
                
       $page_title = 'Add Leads';
       $sources = HeaderHelper::leadSource();
       $states = HeaderHelper::states();
       $insurances = Insurance::get();

       $teamleads = AssignUser::where('user_id', '=', Auth::user()->id)
       ->join('users','assigned_users.assign_user_id','=','users.id')
       ->select('assigned_users.*','users.name','users.lastname')
       ->get()->toArray();

       $staffs = AssignUser::where('user_id', '=', Auth::user()->id)
       ->join('users as U1','assigned_users.assign_user_id','=','U1.id')
       ->select('assigned_users.assign_user_id','U1.name','U1.lastname')
       ->get()->toArray();

       
       foreach ($staffs as $key => $staff) {
         $staffs = self::GetTeamLeadStaff($staff['assign_user_id']);
        }
       return view('admin/supervisiors/add', compact('page_title','states','staffs','teamleads','sources','insurances'));    
      }

      public function GetTeamLeadStaff($id){ 
        return  AssignUser::where('user_id', '=', $id)
       ->join('users as U1','assigned_users.assign_user_id','=','U1.id')
       ->select('assigned_users.assign_user_id','U1.name','U1.lastname')
       ->get()->toArray();
      }

     public function store(Request $request){ 
      //dd($request);
      $this->validate($request,[
            'contact_no' => 'required|digits:11|numeric',
            
      ]);
      
      $Lead = new Lead;
      $Lead->type = $request->type;
      if($request->type == 'staff'){
        $Lead->user_id = $request->staff_user_role;
      }else if($request->type == 'supervisior'){
        $Lead->user_id = Auth::user()->id;
      }else{
        $Lead->user_id = $request->teamlead_user_role;

      }
      
      $Lead->assigned_by_user_id = Auth::user()->id;

      if($request->type == 'staff'){
        $Lead->user_role = User::where('id','=',$request->staff_user_role)->pluck('user_role')->first();
      }elseif($request->type == 'supervisior'){
        $Lead->user_role= User::where('id','=',$Lead->user_id)->pluck('user_role')->first();

      }else{
       $Lead->user_role = User::where('id','=',$request->teamlead_user_role)->pluck('user_role')->first();

      }
      $Lead->assigned_by_user_name = Auth::user()->name.' '.Auth::user()->lastname;
      $Lead->firstname = $request->firstname;
      $Lead->lastname = $request->lastname;
      $Lead->email = $request->email;

      $Lead->contact_no = $request->contact_no;
     
      $Lead->address = $request->address;
      $Lead->city = $request->city;
      $Lead->state = $request->state;
      /*$Lead->post_code = $request->postcode;*/

      $Lead->lead_source = $request->lead_source;
      $Lead->lead_description = $request->lead_description;
      $Lead->lead_type = $request->lead_type;
      $Lead->orgnisation_type = $request->orgnisation_type;
      if($request->orgnisation_type  ==  'Company'){
        $Lead->nature_of_organisation = $request->nature_of_org_company;
      }else{
         $Lead->nature_of_organisation = $request->nature_of_org_individual;
      }
     
      $Lead->referred_by = $request->referred_by;
      $Lead->save();


       
      return redirect()->route('supervisiors.leads.show')->with('success', 'Lead Create Successfully.');

            
   }

     public function show($id) {
        $lead = Lead::where('id', '=', $id)->first(); 
        $sources = HeaderHelper::leadSource();
        $states = HeaderHelper::states();    
        $teamleads = AssignUser::where('user_id', '=', Auth::user()->id)
       ->join('users','assigned_users.assign_user_id','=','users.id')
       ->select('assigned_users.*','users.name','users.lastname')
       ->get()->toArray();

       $staffs = AssignUser::where('user_id', '=', Auth::user()->id)
       ->join('users as U1','assigned_users.assign_user_id','=','U1.id')
       ->select('assigned_users.assign_user_id','U1.name','U1.lastname')
       ->get()->toArray();

       
       foreach ($staffs as $key => $staff) {
         $staffs = self::GetTeamLeadStaff($staff['assign_user_id']);
        }
        //$teamleads = User::where('user_role', '=', 4)->get()->toArray();  
        $insurances = Insurance::get();
        return view('admin/supervisiors/edit', compact('lead','states','staffs','teamleads','sources','insurances'));    
    }

     public function update(Request $request, $id) {
      //dd($request);
      $this->validate($request,[
           'contact_no' => 'required|digits:11|numeric',
            
      ]);  
      $Lead = Lead::where('id', '=', $id)->first();    
      $Lead->type = $request->type;
      if($request->type == 'staff'){
        $Lead->user_id = $request->staff_user_role;
      }else{
        $Lead->user_id = $request->teamlead_user_role;

      }
      
      $Lead->assigned_by_user_id = Auth::user()->id;
      if($request->type == 'staff'){
        $Lead->user_role = User::where('id','=',$request->staff_user_role)->pluck('user_role')->first();
      }else{
       $Lead->user_role = User::where('id','=',$request->teamlead_user_role)->pluck('user_role')->first();

      }
      $Lead->assigned_by_user_name = Auth::user()->name.' '.Auth::user()->lastname;

      $Lead->firstname = $request->firstname;
      $Lead->lastname = $request->lastname;
      $Lead->email = $request->email;
     
      
      $Lead->contact_no = $request->contact_no;
      $Lead->address = $request->address;

      $Lead->city = $request->city;
      $Lead->state = $request->state;
      /*$Lead->post_code = $request->postcode;*/

      $Lead->lead_source = $request->lead_source;
      $Lead->lead_description = $request->lead_description;
      $Lead->lead_type = $request->lead_type;
      
      $Lead->orgnisation_type = $request->orgnisation_type;
      if($request->orgnisation_type  ==  'Company'){
        $Lead->nature_of_organisation = $request->nature_of_org_company;
      }else{
         $Lead->nature_of_organisation = $request->nature_of_org_individual;
      }
      $Lead->referred_by = $request->referred_by;

      $Lead->save();
               

      

    return redirect()->route('supervisiors.leads.show')->with('success', 'Lead Update Successfully.');
    }

  

     public function destroy($id) {
        $c = Lead::find($id); 
        $c->delete();
        return redirect()->route('supervisiors.leads.show')->with('success', 'Lead Delete Successfully.');
    }

   public function importExportView(Request $request){                 
       $page_title = 'Add Import';
       return view('admin/supervisiors/import', compact('page_title'));    
      }
    
    public function import(Request $request)   {
      $this->validate($request, [
         'file'=> 'required|mimes:xls,xlsx'
     ]);

      $path = $request->file('file')->getRealPath();
      Excel::import(new BulkImport,request()->file('file'));
      return redirect()->route('supervisiors.leads.show')->with('success', 'Excel Data Imported successfully.');

    }


    public function exportCsv(Request $request){
      $fileName = '';
      $leads = [];
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
        $fileName = 'leadsbtw-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv';
        $leads =  Lead::where('assigned_by_user_id','=',Auth::user()->id)
                      ->whereBetween('leads.created_at',[$request->input('start_date'), $request->input('stop_date')])
                      ->join('users', 'leads.user_id', '=', 'users.id')
                      ->select('leads.*','users.name as staffname')
                      ->get();
      }
      else{
        $fileName = 'leads.csv';
        $leads =  Lead::where('assigned_by_user_id','=',Auth::user()->id)
                        ->join('users', 'leads.user_id', '=', 'users.id')
                        ->select('leads.*','users.name as staffname')
                        ->get();
      }


   
        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

        $columns = array('Assigned By', 'Name', 'Email', 'Contact','Addess','City','Lead Type','Organisation Type','Referred by');

            $callback = function() use($leads, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($leads as $account) {
                $row['Assigned By']   = $account->assigned_by_user_name;
                $row['Name']     = $account->firstname.' '.$account->lastname;
                $row['Email']     = $account->email;
                $row['Contact']   = $account->contact_no;
                $row['Addess']       = $account->address;
                $row['City'] = $account->city;
                $row['Lead Type']   = $account->lead_type;
                $row['Organisation Type']  = $account->orgnisation_type;
                $row['Referred by']  = $account->referred_by;

                fputcsv($file, array($row['Assigned By'], $row['Name'], $row['Email'], $row['Contact'], $row['Addess'], $row['City'], $row['Lead Type'], $row['Organisation Type'],$row['Referred by']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }

    

}

