<?php


namespace App\Http\Controllers\Admin\Staff;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\BulkExport;
use App\Imports\BulkImport;

use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\User;
use App\Models\Policy;
use App\Models\Sale;
use Validator;
use Image;
use Auth;
use Carbon\Carbon;
use GuzzleHttp\Client;

class PolicyController extends Controller

{    

    public function renewals_old(Request $request){     
    
    $page_title = 'Policy Renewals';    
    /*$renewals = Sale::where('expire', '<=', Carbon::now()->addDays(62))
    ->join('leads', 'sales.lead_id', '=', 'leads.id')
    ->select('sales.*','leads.firstname as name')
    ->get();*/

    

    if($request->search == 'Search'){
         //dd($request);
    //dd($request);
    $client = new Client();
    $response = $client->request('POST', 'https://enterprise.veritaskapital.net/api/renewals',[
    'form_params' => [
        'effective_date' => $request->effective_date,
        'expiration_date' => $request->expiration_date,
        'sum_insured' => $request->premium,
        'insured_name' => $request->insured_name,
        'branch' => $request->branch,
        'agent' => $request->agency,
        'pol_num' => $request->pol_num,
        'pol_class' => $request->pol_class,
        'clo_id' => $request->clo_id,
        'clo_name' => $request->clo_name,
        'cover_start' => $request->cover_start,
        'cover_end' => $request->cover_end,
        ]]);
    $statusCode = $response->getStatusCode();
    $renewals = $response->getBody()->getContents();
    $renewals = json_decode($renewals);
    //dd($renewals);

    $effective_date = $request->effective_date;
    $expiration_date = $request->expiration_date;
    $foundflag = false;
    $array     = [];
    $i         = 0;
    foreach ($renewals->data as $renewal) {
        $insured_period = explode('To',$renewal->insured_period);
        $start_insured= $insured_period[0];
        $stop_insured = $insured_period[1];
        if($renewal->clo == Auth::user()->clo_id){

             $foundflag = true;
             $array[$i]['customer_name'] = $renewal->customer_name;
             $array[$i]['policy_type'] = $renewal->policy_type;
             $array[$i]['clo_name'] = $renewal->clo_name;
             $array[$i]['policy_number'] = $renewal->policy_number;
             $array[$i]['sales_amount'] = number_format($renewal->sales_amount);
             $array[$i]['expiration_date'] = $renewal->expiration_date;
             $array[$i]['agency_name'] = $renewal->agency_name;
             $array[$i]['effective_date'] = $renewal->effective_date;
             $array[$i]['start_insured_period'] = $start_insured;
            $array[$i]['stop_insured_period'] = $stop_insured;



        }
      
        $i++;
    }
    $sales = $array;
   
    $effective_date = $request->effective_date;
    $expiration_date = $request->expiration_date;
    $premium = $request->premium;
    $insured_name = $request->insured_name;
    $branch = $request->branch;
    $agent = $request->agency;
    $pol_num = $request->pol_num;
    $pol_class = $request->pol_class;
    $clo_id = $request->clo_id;
    $clo_name = $request->clo_name;
    $cover_start = $request->cover_start;
    $cover_end = $request->cover_end;

    }else{

    $client = new Client();
    $response = $client->request('GET', 'https://enterprise.veritaskapital.net/api/renewals');
    $statusCode = $response->getStatusCode();
    $renewals = $response->getBody()->getContents();
    $renewals = json_decode($renewals);

    $effective_date = '';
    $expiration_date = '';

    $foundflag = false;
    $array     = [];
    $i         = 0;
    foreach ($renewals->data as $renewal) {
        $insured_period = explode('To',$renewal->insured_period);
        $start_insured= $insured_period[0];
        $stop_insured = $insured_period[1];
        if($renewal->clo == Auth::user()->clo_id){

             $foundflag = true;
             $array[$i]['customer_name'] = $renewal->customer_name;
             $array[$i]['policy_type'] = $renewal->policy_type;
             $array[$i]['clo_name'] = $renewal->clo_name;
             $array[$i]['policy_number'] = $renewal->policy_number;
             $array[$i]['sales_amount'] = number_format($renewal->sales_amount);
             $array[$i]['expiration_date'] = $renewal->expiration_date;
             $array[$i]['agency_name'] = $renewal->agency_name;
             $array[$i]['effective_date'] = $renewal->effective_date;
             $array[$i]['start_insured_period'] = $start_insured;
             $array[$i]['stop_insured_period'] = $stop_insured;



        }
     
        $i++;
    }

    $sales = $array;
    $effective_date = '';
    $expiration_date = '';
    $premium = '';
    $insured_name = '';
    $branch = '';
    $agent = '';
    $pol_num = '';
    $pol_class = '';
    $clo_id = '';
    $clo_name = '';
    $cover_start = '';
    $cover_end = '';
    }
   
   $renewals = $array;
   
    return view('admin/staff/policy/index', compact('page_title', 'renewals','effective_date','expiration_date','premium','insured_name','branch','agent','pol_num','pol_class','clo_id','clo_name','cover_start','cover_end'));    
   }
   
   public function renewals(Request $request)
{     
    ini_set('memory_limit', '256M');
    
    $page_title = 'Policy Renewals';

    $client = new Client();
    $apiUrl = ($request->search == 'Search') ? 'https://enterprise.veritaskapital.net/api/renewals' : 'https://enterprise.veritaskapital.net/api/renewals';

    $response = $client->request(($request->search == 'Search') ? 'POST' : 'GET', $apiUrl, [
        'form_params' => [
            'effective_date' => $request->effective_date,
            'expiration_date' => $request->expiration_date,
            'sum_insured' => $request->premium,
            'insured_name' => $request->insured_name,
            'branch' => $request->branch,
            'agent' => $request->agency,
            'pol_num' => $request->pol_num,
            'pol_class' => $request->pol_class,
            'clo_id' => $request->clo_id,
            'clo_name' => $request->clo_name,
            'cover_start' => $request->cover_start,
            'cover_end' => $request->cover_end,
        ]
    ]);

    $statusCode = $response->getStatusCode();
    $renewalsData = json_decode($response->getBody()->getContents())->data;

    $renewals = [];
    foreach ($renewalsData as $renewal) {
        $insured_period = explode('To', $renewal->insured_period);
        $start_insured = $insured_period[0];
        $stop_insured = $insured_period[1];

        if ($renewal->clo == Auth::user()->clo_id) {
            $renewals[] = [
                'customer_name' => $renewal->customer_name,
                'policy_type' => $renewal->policy_type,
                'clo_name' => $renewal->clo_name,
                'policy_number' => $renewal->policy_number,
                'sales_amount' => number_format($renewal->sales_amount),
                'expiration_date' => $renewal->expiration_date,
                'agency_name' => $renewal->agency_name,
                'effective_date' => $renewal->effective_date,
                'start_insured_period' => $start_insured,
                'stop_insured_period' => $stop_insured,
            ];
        }
    }

    $effective_date = ($request->search == 'Search') ? $request->effective_date : '';
    $expiration_date = ($request->search == 'Search') ? $request->expiration_date : '';
    $premium = ($request->search == 'Search') ? $request->premium : '';
    $insured_name = ($request->search == 'Search') ? $request->insured_name : '';
    $branch = ($request->search == 'Search') ? $request->branch : '';
    $agent = ($request->search == 'Search') ? $request->agency : '';
    $pol_num = ($request->search == 'Search') ? $request->pol_num : '';
    $pol_class = ($request->search == 'Search') ? $request->pol_class : '';
    $clo_id = ($request->search == 'Search') ? $request->clo_id : '';
    $clo_name = ($request->search == 'Search') ? $request->clo_name : '';
    $cover_start = ($request->search == 'Search') ? $request->cover_start : '';
    $cover_end = ($request->search == 'Search') ? $request->cover_end : '';

    return view('admin/staff/policy/index', compact('page_title', 'renewals', 'effective_date', 'expiration_date', 'premium', 'insured_name', 'branch', 'agent', 'pol_num', 'pol_class', 'clo_id', 'clo_name', 'cover_start', 'cover_end'));
}


  
    public function exportCsv(Request $request){
      $fileName = ''; 
      $foundflag = false;
      $array     = [];
      $renewals = [];
      $i         = 0;   
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
        $fileName = 'renewalsbtw-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv'; 
        $client = new Client();
        $response = $client->request('POST', 'https://enterprise.veritaskapital.net/api/renewals',[
            'form_params' => [
                'effective_date' => $request->input('start_date'),
                'expiration_date' => $request->input('stop_date'),
              ]]);
        $statusCode = $response->getStatusCode();
        $renewals = $response->getBody()->getContents();
        $renewals = json_decode($renewals);
      }
      else{
        $fileName = 'renewals.csv'; 
        $client = new Client();
        $response = $client->request('GET', 'https://enterprise.veritaskapital.net/api/renewals');
        $statusCode = $response->getStatusCode();
        $renewals = $response->getBody()->getContents();
        $renewals = json_decode($renewals);
      }
    
    foreach ($renewals->data as $renewal) {
        $insured_period = explode('To',$renewal->insured_period);
        $start_insured= $insured_period[0];
        $stop_insured = $insured_period[1];
        if($renewal->clo == Auth::user()->clo_id){

             $foundflag = true;
             $array[$i]['customer_name'] = $renewal->customer_name;
             $array[$i]['policy_type'] = $renewal->policy_type;
             $array[$i]['clo_name'] = $renewal->clo_name;
             $array[$i]['policy_number'] = $renewal->policy_number;
             $array[$i]['sales_amount'] = number_format($renewal->sales_amount);
             $array[$i]['expiration_date'] = $renewal->expiration_date;
             $array[$i]['agency_name'] = $renewal->agency_name;
             $array[$i]['effective_date'] = $renewal->effective_date;
             $array[$i]['start_insured_period'] = $start_insured;
             $array[$i]['stop_insured_period'] = $stop_insured;



        }
     
        $i++;
    }

    
    $staffrenewals = $array;

    
        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Purchased By', 'Policy Type','Clo Name','Policy Number', 'Policy Premium', 'Policy Expire','Agency','Effective Date','Start_Policy_Period', 'Stop_Policy_Period');

            $callback = function() use($staffrenewals, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
            // dd($staffrenewals);
            foreach ($staffrenewals as $renewal) {
                $row['Purchased By']        = $renewal['customer_name'];
                $row['Policy Type']         = $renewal['policy_type'];
                $row['Clo Name']            = $renewal['clo_name'];
                $row['Policy Number']       = $renewal['policy_number'];
                $row['Policy Premium']      = $renewal['sales_amount'];
                $row['Policy Expire']       = $renewal['expiration_date'];
                $row['Agency']              = $renewal['agency_name'];
                $row['Effective Date']      = $renewal['effective_date'];
                
                $row['Start_Policy_Period']       = $renewal['start_insured_period'];
                $row['Stop_Policy_Period']       = $renewal['stop_insured_period'];
                
             
               
            fputcsv($file, array( $row['Purchased By'], $row['Policy Type'],$row['Clo Name'], $row['Policy Number'], $row['Policy Premium'], $row['Policy Expire'],$row['Agency'],$row['Effective Date'],$row['Start_Policy_Period'], $row['Stop_Policy_Period']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }
    

}

