<?php



namespace App\Http\Controllers\Admin\Staff;

use Illuminate\Http\Request as HttpRequest;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\DB;
use App\Helpers\HeaderHelper;
use App\Helpers\EmailHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\User;
use App\Models\Sale;
use App\Models\Lead;
use App\Models\Insurance;
use Validator;
use Image;
use Auth;


class LeadController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Leads'; 
      $start_date = $request->start_date;
      $stop_date = $request->stop_date;   
    $assigned_by = $request->assigned_by;
    if($request->search == 'Search'){
      if(isset($request->assigned_by)){
        $leads = Lead::join('users', 'leads.user_id', '=', 'users.id')
              ->where('assigned_by_user_id','=',Auth::user()->id)
              ->whereBetween('leads.created_at',[$start_date, $stop_date])
              ->where('leads.assigned_by_user_name','like',"%{$assigned_by}%")
              ->select('leads.*','users.name as staffname')  
              ->orderby('leads.created_at', 'desc')
              ->get(); 
      }
      else{
        $leads = Lead::where('assigned_by_user_id','=',Auth::user()->id)
              ->join('users', 'leads.user_id', '=', 'users.id')
              ->whereBetween('leads.created_at',[$start_date, $stop_date])
              ->select('leads.*','users.name as staffname')  
              ->orderby('leads.created_at', 'desc')
              ->get(); 
      }
      
    }else{


    $leads = Lead::where('assigned_by_user_id','=',Auth::user()->id)
    ->join('users', 'leads.user_id', '=', 'users.id')
    ->select('leads.*','users.name as staffname')  
    ->orderby('leads.created_at', 'desc')
    ->get();  
    

    }
      // dd($leads);
    return view('admin/staff/index', compact('page_title', 'leads','start_date','stop_date','assigned_by'));    
   }

    public function assignedLeads(Request $request){     
    $page_title = 'Assigned Leads';    
     
    Lead::where('user_id','=',Auth::user()->id)->where('created_at','>=',date('Y-m-d'))->update(['notify_status'=>false]);
    $assigned_by = $request->assigned_by;
    $clo_name = $request->clo_name;
    $start_date = $request->start_date;
    $stop_date = $request->stop_date;
    if($request->search == 'Search'){
      
      if(isset($request->assigned_by)){
        $leads = Lead::where('user_id','=',Auth::user()->id)
                      ->whereBetween('leads.created_at',[$start_date, $stop_date])
                      ->where('assigned_by_user_name','like',"%{$request->assigned_by}%")
                      ->orderby('leads.updated_at', 'desc')
                      ->get(); 
      }else{
        $leads = Lead::where('user_id','=',Auth::user()->id)
                      ->whereBetween('leads.created_at',[$start_date, $stop_date])
                      ->orderby('leads.updated_at', 'desc')
                      ->get(); 
      }
    }
    else{
      $leads = Lead::where('user_id','=',Auth::user()->id)->orderby('leads.created_at', 'desc')
               ->get(); 
    }
    return view('admin/staff/leads', compact('page_title', 'leads','assigned_by','start_date','stop_date'));    
   }


    public function create(Request $request){                 
       $page_title = 'Add Leads';
       $states   = HeaderHelper::states();
       $sources  = HeaderHelper::leadSource();
       $authID   = Auth::user()->id;
       $staffs = User::where('user_role', '=', 3)->get()->toArray();
       $insurances = Insurance::get();
       // /dd($staffs);
       return view('admin/staff/add', compact('page_title','states','sources','authID','staffs','insurances'));    
      }

    public function store(Request $request){ 
     
      $this->validate($request,[
            'contact_no' => 'min:11|numeric',
            
      ]);
      $Lead = new Lead;
      $Lead->user_id = $request->user_id;
      $Lead->type = 'staff';
      $Lead->assigned_by_user_id = Auth::user()->id;
      $Lead->user_role = User::where('id','=',$request->user_id)->pluck('user_role')->first();
      $Lead->assigned_by_user_name = Auth::user()->name.' '.Auth::user()->lastname;
      $Lead->firstname = $request->firstname;
      $Lead->lastname = $request->lastname;
      $Lead->email = $request->email;      
      $Lead->contact_no = $request->contact_no;
      //$Lead->clo_id = $request->clo_id;
        $Lead->clo_name = $request->clo_name;

      $Lead->address = $request->address;
      /*$Lead->city = $request->city;
      $Lead->state = $request->state;
      $Lead->post_code = $request->postcode;*/

      $Lead->lead_source = $request->lead_source;
      $Lead->lead_description = $request->lead_description;
      $Lead->lead_type = $request->lead_type;
      $Lead->orgnisation_type = $request->orgnisation_type;
      if($request->orgnisation_type  ==  'Company'){
        $Lead->nature_of_organisation = $request->nature_of_org_company;
      }else{
         $Lead->nature_of_organisation = $request->nature_of_org_individual;
      }
      $Lead->referred_by = $request->referred_by;
      
      $Lead->save();

     /* if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "lead." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/teamLead/leads'), $fileName);

            if ($Lead->image != 'photo.jpg' && is_file(public_path('uploads/site/teamLead/leads' . $Lead->image))) {
                unlink(public_path('uploads/site/teamLead/leads' . $Lead->image));
            }
            $Lead->image = 'uploads/site/teamLead/leads'.'/'.$fileName;
            $Lead->save();
        }*/

       
      return redirect()->route('staff.leads.show')->with('success', 'Lead Create Successfully.');

            
   }

    public function show($id) {
        $lead = Lead::where('id', '=', $id)->first(); 
        $states   = HeaderHelper::states();
        $sources  = HeaderHelper::leadSource();
        $authID   = Auth::user()->id;
        $staffs = User::where('user_role', '=', 3)->get()->toArray();
        $insurances = Insurance::get();
       // /dd($staffs);   
        return view('admin/staff/edit', compact('lead','states','sources','authID','staffs','insurances'));    
    }

    public function update(Request $request, $id) {
    // /dd($request);
      $this->validate($request,[
           'contact_no' => 'required|digits:11|numeric',
            
      ]);  
      $Lead = Lead::where('id', '=', $id)->first();    

      $Lead->user_id = $request->user_id;
      $Lead->type = 'staff';
      $Lead->assigned_by_user_id = Auth::user()->id;
      $Lead->user_role = User::where('id','=',$request->user_id)->pluck('user_role')->first();
      
      $Lead->assigned_by_user_name = Auth::user()->name.' '.Auth::user()->lastname;

      $Lead->firstname = $request->firstname;
      $Lead->lastname = $request->lastname;
      $Lead->email = $request->email;
     
      
      $Lead->contact_no = $request->contact_no;
      $Lead->address = $request->address;

      /*$Lead->city = $request->city;
      $Lead->state = $request->state;
      $Lead->post_code = $request->postcode;*/

      $Lead->lead_source = $request->lead_source;
      $Lead->lead_description = $request->lead_description;
      $Lead->lead_type = $request->lead_type;
      
      $Lead->orgnisation_type = $request->orgnisation_type;
      if($request->orgnisation_type  ==  'Company'){
        $Lead->nature_of_organisation = $request->nature_of_org_company;
      }else{
         $Lead->nature_of_organisation = $request->nature_of_org_individual;
      }
      $Lead->referred_by = $request->referred_by;

      $Lead->save();
      /*if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "lead." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/teamLead/leads'), $fileName);

            if ($Lead->image != 'photo.jpg' && is_file(public_path('uploads/site/teamLead/leads' . $Lead->image))) {
                unlink(public_path('uploads/site/teamLead/leads' . $Lead->image));
            }
            $Lead->image = 'uploads/site/teamLead/leads'.'/'.$fileName;
            $Lead->save();
        }  */          

      

    return redirect()->route('staff.leads.show')->with('success', 'Lead Update Successfully.');
    }

    public function destroy($id) {
        $c = Lead::find($id); 
        $c->delete();
        return redirect()->route('staff.leads.show')->with('success', 'Lead Delete Successfully.');
    }

    public function details($id) {
        $lead = Lead::where('id', '=', $id)->first(); 
        $insurances = Insurance::get();
        //dd($insurances);          
        return view('admin/staff/detail', compact('lead','insurances'));  
    }
    
    public function lookupDebitNote(Request $request, $id)
    {
        // If you need to ensure the lead exists:
        $lead = Lead::query()->findOrFail($id);

        $data = $request->validate([
            'debit_note' => ['required', 'string', 'max:25'],
        ]);

        // IMPORTANT: change 'nlfaccount' if your real table name differs.
        $row = DB::connection('IES_DB')
            ->table('nlfaccounts')
            ->join('nlfagency','nlfagency.code', '=','nlfaccounts.account')
            ->join('nlfpolmain','nlfpolmain.polnum', '=','nlfaccounts.polnum')
            ->where('dcnumb', $data['debit_note'])
            ->first();

        if (!$row) {
            return response()->json([
                'ok' => false,
                'message' => 'No matching record found for that Debit Note number.',
            ], 404);
        }

        $payload = [
            'debit_note'       => $row->dcnumb,
            'policy_number'    => $row->polnum ?? null,
            'transaction_date' => $row->trndate ?? null,
            'effective_date'   => $row->efcdate ?? null,
            'entry_date'       => $row->entdate ?? null,
            'gross_premium'    => $row->tgross ?? 0,
            'commission'       => $row->tcomm ?? 0,
            'net_premium'      => $row->trnnet ?? 0,
            'narration'        => $row->trnnar ?? null,
            'client'           => $row->client ?? null,
            'branch'           => $row->branch ?? null,
            'currency'         => $row->currency ?? null,
            'rate'             => $row->currate ?? null,
            'insured'          => $row->insured ?? null,
            'geocover'         => $row->geocover ?? null,
            'agency'           => $row->name ?? null,
            'polclass'         => $row->polclass ?? null,
            'tgross'           => $row->tgross ?? null,
            'region'           => $row->region ?? null,
            
        ];

        return response()->json(['ok' => true, 'data' => $payload]);
    }
    
    public function convertFromDebitNote(Request $request, $id)
    {
       $lead = Lead::findOrFail($id);

        $validated = $request->validate([
            'debit_note'       => ['required','string','max:25'],
            'policy_number'    => ['nullable','string','max:40'],
            'transaction_date' => ['nullable','date'],
            'effective_date'   => ['nullable','date'],
            'entry_date'       => ['nullable','date'],
            'gross_premium'    => ['nullable','numeric'],
            'commission'       => ['nullable','numeric'],
            'net_premium'      => ['nullable','numeric'],
            'narration'        => ['nullable','string','max:255'],
            'client'           => ['nullable','string','max:255'],
            'branch'           => ['nullable','string','max:10'],
            'currency'         => ['nullable','string','max:12'],
            'rate'             => ['nullable','numeric'],
            'agency'           => ['nullable','string','max:255'],
            'geocover'         => ['nullable','string','max:12'],
            'polclass'         => ['nullable','string','max:12'],   // you’re saving text already
            'tgross'           => ['nullable','numeric'],
            'region'           => ['nullable','string'],            // treat as string if zero-padded
        ]);
        
        if($validated['region'] ==="0007"){
            $email = '["northcrmsale@veritaskapital.com"]';
        }elseif($validated['region'] ==="0006"){{
            $email = '["southcrmsale@veritaskapital.com"]';
        }
        

        // Fallback if you don’t have a Sale model yet: insert directly
        $insuranceId = DB::table('sales')->insertGetId([
            'user_id'              => auth()->id() ?? null,
            'assigned_by_user_id'  => $validated['assigned_by_user_id'] ?? null,
            'lead_id'              => $lead->id ?? null,
            //'insurance_id'         => $validated['insurance_id'] ?? null,
            'insurance_name'       => $validated['polclass'] ?? null,
            //'expire'               => $validated['expire'] ?? null,
            'price'                => $validated['tgross'] ?? 0,
            //'insurance_no'         => $validated['policy_number'] ?? null,
            //'client_code'          => $validated['client'] ?? null,
            //'agency_category_id'   => $validated['agency_category_id'] ?? null,
            'agency'               => $validated['agency'] ?? null,
            //'insurance_class'      => $validated['polclass'] ?? null,
            //'insurance_type'       => $validated['insurance_type'] ?? null,
            //'business_type'        => $validated['business_type'] ?? null,
            //'insurance_group'      => $validated['insurance_group'] ?? null,
            'reference'            => $validated['narration'] ?? null,
            'currency'             => $validated['currency'] ?? null,
            //'rate'                 => $validated['rate'] ?? null,
            'issuance_date'        => $validated['entry_date'] ?? null,
            'term'                 => '365',
            'cover_period_from'    => $validated['effective_date'] ?? null,
            'cover_period_to'      => $validated['entry_date'] ?? null,
            'insurance_branch'     => $validated['branch'] ?? null,
            'limit_of_exposure'    => null,
            'business_location'    => null,
            'geographical_cover'   => $validated['geocover'] ?? null,
            'occupational_exposure'=> null,
            'insurance_status'     => 'sale',
            'email'                => $email,
            'email_sent'           => 'No',
            'created_at'           => now(),
            'updated_at'           => now(),
        ]);
        
        
        $mailPayload = [
            'insurance_no'        => $validated['policy_number'] ?? null,
            'client_code'         => $validated['client'] ?? null,
            'agency'              => $validated['agency'] ?? null,
            'insurance_class'     => $validated['polclass'] ?? null, // text label
            'insurance_type'      => null,
            'business_type'       => null,
            'insurance_group'     => null,
            'reference'           => $validated['narration'] ?? null,
            'currency'            => $validated['currency'] ?? null,
            'rate'                => $validated['rate'] ?? null,
            'issuance_date'       => $validated['entry_date'] ?? null,
            'term'                => '365',
            'cover_period_from'   => $validated['effective_date'] ?? null,
            'cover_period_to'     => $validated['entry_date'] ?? null,
            'limit_of_exposure'   => null,
            'insurance_branch'    => $validated['branch'] ?? null,
            'business_location'   => null,
            'geographical_cover'  => $validated['geocover'] ?? null,
            'occupational_exposure'=> null,
            'clo_name'            => null,
            'user_id'             => auth()->id(),
            'insurance_status'    => 'sale',
            'email'               => $email,     // <-- array, not JSON string
        ];
        
        $user = User::find(auth()->id());
        $clo = $user->name .' '.$user->lastname;

        $mailReq = new HttpRequest();
        $mailReq->replace($mailPayload);
    
        EmailHelper::leadConvertToSale($lead->id);
        $sent = EmailHelper::sendEmailToUser($mailReq, $clo);
    
        $sale = Sale::find($insuranceId);
        if ($sent && $sale) {
            $sale->email_sent = 'Yes';
            $sale->save();
        }


        return response()->json([
            'ok'      => true,
            'message' => 'Sale conversion completed.',
            'sale_id' => $insuranceId,
        ]);
    }

    public function getCompanies(Request $request) {
        return $insurances = Insurance::where('name','like',$request->term.'%')->select('name')->first();
        //dd($insurances);     

        //return view('admin/staff/detail', compact('lead','insurances'));  
    }

    
    public function exportCsv(Request $request){
      $fileName = '';
      $leads = [];
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
        $fileName = 'leadsbtw-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv';
        $leads =  Lead::where('assigned_by_user_id','=',Auth::user()->id)
          ->orWhere('leads.user_role','=',3)
          ->whereBetween('leads.created_at',[$request->input('start_date'),$request->input('stop_date')])
          ->join('users', 'leads.user_id', '=', 'users.id')
          ->select('leads.*','users.name as fullname')
          ->get();
      }
      else{
        $fileName = 'leads.csv';
        $leads =  Lead::where('assigned_by_user_id','=',Auth::user()->id)
        ->orWhere('leads.user_role','=',3)
        ->join('users', 'leads.user_id', '=', 'users.id')
        ->select('leads.*','users.name as fullname')
        ->get();
      }


   
        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

        $columns = array('Assigned By', 'Name', 'Email', 'Contact','Addess','City','Lead Type','Organisation Type','Referred by');

            $callback = function() use($leads, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($leads as $account) {
                $row['Assigned By']   = $account->assigned_by_user_name;
                $row['Name']     = $account->firstname.' '.$account->lastname;
                $row['Email']     = $account->email;
                $row['Contact']   = $account->contact_no;
                $row['Addess']       = $account->address;
                $row['City'] = $account->city;
                $row['Lead Type']   = $account->lead_type;
                $row['Organisation Type']  = $account->orgnisation_type;
                $row['Referred by']  = $account->referred_by;

                fputcsv($file, array($row['Assigned By'], $row['Name'], $row['Email'], $row['Contact'], $row['Addess'], $row['City'], $row['Lead Type'], $row['Organisation Type'],$row['Referred by']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }

    

}

