<?php



namespace App\Http\Controllers\Admin\Staff\Call;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\Lead;
use App\Models\User;
use App\Models\Policy;
use App\Models\Agency;
use App\Models\CallActivity;
use App\Models\CustomerActivity;
use App\Models\ProspectsActivity;
use App\Models\CallingActivity;
use Validator;
use Image;
use Auth;



class CallActivityController extends Controller

{    

   public function index(Request $request){     
    $page_title = 'Call Activity Reports';  
    $follow_up = $request->follow_up;
    $start_date = $request->start_date;
    $stop_date = $request->stop_date;
       if($request->search == 'Search'){  
         if($request->follow_up){
            $activities = CallingActivity::where('user_id','=',Auth::user()->id)
            ->whereBetween('callings.created_at',[$request->start_date, $request->stop_date])
            ->where('callings.follow_up_date',$request->follow_up)
            ->orderby('callings.created_at', 'desc')
            ->get();
         }
         else{
            $activities = CallingActivity::where('user_id','=',Auth::user()->id)
            ->whereBetween('callings.created_at',[$request->start_date, $request->stop_date])
            ->orderby('callings.created_at', 'desc')
            ->get();
         }

    }else{

      $activities = CallingActivity::where('user_id','=',Auth::user()->id)->orderby('callings.created_at', 'desc')->get();  
    
    } 

   //  dd($activities);
    
    return view('admin/staff/callactivity/index', compact('page_title', 'activities','start_date','stop_date','follow_up'));    
   }


    public function create(Request $request){                 
        
       $page_title = 'Add Call Notes';
       $brokers = Agency::where('agency_category_id','=', 1)->get();
       return view('admin/staff/callactivity/add', compact('page_title','brokers'));    
      }

     public function store(Request $request){ 
     if($request->date > date('Y-m-d')){
      //   dd("date cannot be more than today's date");
        return back()->with('error',"date cannot be more than today's date");
     }
     if(isset($request->follow_up_date) && $request->follow_up_date < date('Y-m-d')){
      //   dd("follow up date cannot be less than today's date");
      return back()->with('error',"follow up date cannot be less than today's date");
     }
      $Activity = new CallingActivity;
      $Activity->user_id = Auth::user()->id;
      $Activity->user_role = Auth::user()->user_role;
      $Activity->subject = $request->subject;
      $Activity->mode_of_activity = $request->mode_of_activity;
      $Activity->type_of_activity = $request->type_of_activity;
      $Activity->description = $request->description;
      $Activity->date = $request->date;

      $Activity->follow_up = $request->follow_up;
      if($request->follow_up == "Yes"){
         $Activity->follow_up_date = $request->follow_up_date;  
      }else{
        $Activity->follow_up_date = $request->follow_up_date; 
      }
      
      $Activity->save();
      return redirect()->route('staff.reports.callactivity.show')->with('success', 'Call Add Successfully.');

            
   }

     public function show($id) {
        $activity = CallingActivity::where('id', '=', $id)->first(); 
         
        return view('admin/staff/callactivity/edit', compact('activity'));    
    }

     public function update(Request $request, $id) {
        //dd($request);
      $Activity = CallingActivity::where('id', '=', $id)->first();
      $Activity->user_id = Auth::user()->id;
      $Activity->user_role = Auth::user()->user_role;
      $Activity->subject = $request->subject;
      $Activity->mode_of_activity = $request->mode_of_activity;
      $Activity->type_of_activity = $request->type_of_activity;
      $Activity->description = $request->description;
      $Activity->date = $request->date;      
      $Activity->follow_up = $request->follow_up;
      if($request->follow_up == "Yes"){
         $Activity->follow_up_date = $request->follow_up_date;  
      }else{
        $Activity->follow_up_date = $request->follow_up_date;
      }
      
      $Activity->save();            

    return redirect()->route('staff.reports.callactivity.show')->with('success', 'Call Update Successfully .');
    }



   

     public function destroy($id) {
        $a = CallingActivity::find($id); 
        $a->delete(); //delete the User
        return redirect()->route('staff.reports.callactivity.show')->with('success', 'Call  Delete Successfully.');
    }


     public function getBrokers(Request $request) {
      // dd($request);
        return $brokers = Agency::where('agency_category_name','like', $request->term)->get();
    }


    public function exportCSV(Request $request){
      $fileName = ''; 
      $foundflag = false;
      $array     = [];
      $activities = [];
      $i         = 0;   
   
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
         $fileName = 'activitybtw-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv'; 
         $activities = CallingActivity::where('user_id','=',Auth::user()->id)->whereBetween('callings.created_at',[$request->input('start_date'),$request->input('stop_date')])->get();   

      }
      else{
         $fileName = 'activity.csv'; 
         $activities = CallingActivity::where('user_id','=',Auth::user()->id)->get(); 
      }

       $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Subject', 'Mode Of Activity', 'Date','Follow Up');

            $callback = function() use($activities, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($activities as $activity) {

                  if($activity->follow_up== 'Yes'){
                   
                   $follow_up =   date('d-M-Y', strtotime($activity->follow_up_date));
                   }else{

                      $follow_up = '';
                   }
                  
                
                $row['Subject']                  = $activity->subject;
                $row['Mode Of Activity']         = $activity->mode_of_activity;
                $row['Type Of Activity']         = $activity->type_of_activity;
                $row['Date']                     = date('d-M-Y', strtotime($activity->date));
                $row['Follow Up']                = $follow_up;
                
               fputcsv($file, array( $row['Subject'], $row['Mode Of Activity'], $row['Type Of Activity'], $row['Date'], $row['Follow Up']));
            }

            fclose($file);
        };

        
        return response()->stream($callback, 200, $headers);
    }

    
    
    

}

