<?php



namespace App\Http\Controllers\Admin\Reports;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\Lead;
use App\Models\User;
use App\Models\Policy;
use App\Models\CallActivity;
use App\Models\CustomerActivity;
use App\Models\ProspectsActivity;
use App\Models\CallingActivity;
use App\Models\AssignUser;
use Validator;
use Image;
use Auth;



class CallActivityController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Call Activity Reports';  
    $follow_up = $request->follow_up;
    $start_date = $request->start_date;
    $stop_date = $request->stop_date;
     if($request->search == 'Search'){     
      if(isset($request->follow_up)){
        $activities =  CallingActivity::whereBetween('callings.created_at',[$request->start_date, $request->stop_date])
                        ->join('users', 'callings.user_id', '=', 'users.id')
                        ->where('callings.follow_up_date',$request->follow_up)
                        ->select('callings.*','users.name','users.username','users.email')
                        ->orderby('callings.created_at', 'desc')
                        ->get();
      }else{
        $activities =  CallingActivity::whereBetween('callings.created_at',[$request->start_date, $request->stop_date])
                      ->join('users', 'callings.user_id', '=', 'users.id')
                      ->select('callings.*','users.name','users.username','users.email')
                      ->orderby('callings.created_at', 'desc')
                      ->get();
      }
    

      }else{

          $activities =  CallingActivity::join('users', 'callings.user_id', '=', 'users.id')
          ->select('callings.*','users.name','users.username','users.email')
          ->orderby('callings.created_at', 'desc')
          ->get();

      }
   
    return view('admin/reports/callactivity/index', compact('page_title', 'activities','start_date','stop_date','follow_up'));    
   }

   


    public function create(Request $request){                 
       $page_title = 'Add Call Notes';
       return view('admin/reports/callactivity/add', compact('page_title'));    
      }

     public function store(Request $request){ 
         
      if($request->date > date('Y-m-d')){
        //   dd("date cannot be more than today's date");
          return back()->with('error',"date cannot be more than today's date");
       }
       if(isset($request->follow_up_date) && $request->follow_up_date < date('Y-m-d')){
        //   dd("follow up date cannot be less than today's date");
        return back()->with('error',"follow up date cannot be less than today's date");
       }
       
      $Activity = new CallingActivity;
      $Activity->user_id = Auth::user()->id;
      $Activity->user_role = Auth::user()->user_role;
      $Activity->subject = $request->subject;
      $Activity->mode_of_activity = $request->mode_of_activity;
      $Activity->type_of_activity = $request->type_of_activity;
      $Activity->description = $request->description;
      $Activity->date = $request->date;      
      $Activity->follow_up = $request->follow_up;
      if($request->follow_up == "Yes"){
         $Activity->follow_up_date = $request->follow_up_date;  
      }else{
        $Activity->follow_up_date = $request->follow_up_date;
      }
      
      $Activity->save();
      return redirect()->route('admin.reports.callactivity.show')->with('success', 'Call Add Successfully.');

            
   }

     public function show($id) {
        $activity = CallingActivity::where('id', '=', $id)->first(); 
         
        return view('admin/reports/callactivity/edit', compact('activity'));    
    }

     public function update(Request $request, $id) {
        //dd($request);
      $Activity = CallingActivity::where('id', '=', $id)->first();
      $Activity->user_id = Auth::user()->id;
      $Activity->user_role = Auth::user()->user_role;
      $Activity->subject = $request->subject;
      $Activity->mode_of_activity = $request->mode_of_activity;
      $Activity->type_of_activity = $request->type_of_activity;
      $Activity->description = $request->description;
      $Activity->date = $request->date;      
      $Activity->follow_up = $request->follow_up;
      if($request->follow_up == "Yes"){
         $Activity->follow_up_date = $request->follow_up_date;  
      }else{
        $Activity->follow_up_date = $request->follow_up_date;
      }
      
      $Activity->save();            

    return redirect()->route('admin.reports.callactivity.show')->with('success', 'Call Update Successfully .');
    }



   

     public function destroy($id) {
        $a = CallingActivity::find($id); 
        $a->delete(); //delete the User
        return redirect()->route('admin.reports.callactivity.show')->with('success', 'Call  Delete Successfully.');
    }


    public function exportCSV(Request $request){
      $fileName="";
      $activities=[];
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
        $fileName = 'callactivitybtw-'.$request->input('start_date').'-'.$request->input('stop_date').'.csv'; 
        
        $activities =  CallingActivity::join('users', 'callings.user_id', '=', 'users.id')
          ->whereBetween('callings.created_at',[$request->input('start_date'), $request->input('stop_date')])
          ->select('callings.*','users.name','users.username','users.email')
          ->get();

      }
      else{
        $fileName = 'callactivity.csv'; 
      
        $activities =  CallingActivity::join('users', 'callings.user_id', '=', 'users.id')
          ->select('callings.*','users.name','users.username','users.email')
          ->get();

      }

       $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Name', 'Username', 'Email','Subject','Mode Of Activity','Type Of Activity','Date','Follow Up');

            $callback = function() use($activities, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($activities as $activity) {

              if($activity->follow_up_date ==  'Yes'){
                  $follow_up = date('d-M-Y', strtotime($activity->follow_up_date));
              }else{

                $follow_up = '';
              }
                
                $row['Name']              = $activity->name;
                $row['Username']          = $activity->username;
                $row['Email']             = $activity->email;
                $row['Subject']           = $activity->subject;
                $row['Mode Of Activity']  = $activity->mode_of_activity;
                $row['Type Of Activity']  = $activity->type_of_activity;
                $row['Date']              = date('d-M-Y', strtotime($activity->date));
                $row['Follow Up']         = $follow_up;
                
            fputcsv($file, array( $row['Name'], $row['Username'], $row['Email'], $row['Subject'], $row['Mode Of Activity'], $row['Type Of Activity'], $row['Date'], $row['Follow Up']));
            }

            fclose($file);
        };

        return response()->stream($callback, 200, $headers);
    }

    
    
    

}

