<?php



namespace App\Http\Controllers\Admin\Business;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Helpers\UserHelper;
use App\Mail\SendMail;
use App\Models\Broker;
use App\Models\Contact;
use Validator;
use Image;
use Auth;



class ContactController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Business Contact';    
    $contacts = Contact::get();            
    return view('admin/business/contact/index', compact('page_title','contacts'));    
   }


    public function create(Request $request){                 
       $page_title = 'Create Contact';
       //dd([$leads,$customers]);
       $states = HeaderHelper::states();
       return view('admin/business/contact/add', compact('page_title','states'));    
      }

     public function store(Request $request){ 
       //dd($request);
      $Contact = new Contact;
      $Contact->name = $request->name;
      $Contact->email = $request->email;
      $Contact->gender = $request->gender;
      $Contact->martial_status = $request->martial_status;
      $Contact->mother_maiden_name = $request->mother_maiden_name;
      $Contact->religion = $request->religion;
      $Contact->business_type = $request->business_type;
      $Contact->client_type = $request->client_type;

      $Contact->permanent_address = $request->permanent_address;
      $Contact->name_of_employee = $request->name_of_employee;
      $Contact->office_address = $request->office_address;
      $Contact->town = $request->town;
      $Contact->communication_address = $request->communication_address;
      $Contact->place_of_birth = $request->place_of_birth;


      $Contact->contact_no = $request->contact_no;  
      $Contact->address = $request->address;     
      $Contact->city = $request->city;     
      $Contact->state = $request->state;     
      $Contact->country = $request->country;     
      $Contact->assigne = $request->assigne;     
      $Contact->sector = $request->sector; 
      $Contact->identification = $request->identification; 
      $Contact->status = $request->status; 
      $Contact->pep_indictaor = $request->indicatior; 
          
      $Contact->save();
      return redirect()->route('admin.business.contact.show')->with('success', 'Business Contact Create Successfully.');

            
   }

     public function show($id) {
        $contact = Contact::where('id', '=', $id)->first(); 
        $states = HeaderHelper::states();
        return view('admin/business/contact/edit', compact('contact','states'));    
    }

     public function update(Request $request, $id) {
     
      $Contact = Contact::where('id', '=', $id)->first();
      
      $Contact->name = $request->name;
      $Contact->email = $request->email;
      $Contact->gender = $request->gender;
      $Contact->martial_status = $request->martial_status;
      $Contact->mother_maiden_name = $request->mother_maiden_name;
      $Contact->religion = $request->religion;
      $Contact->business_type = $request->business_type;
      $Contact->client_type = $request->client_type;

      $Contact->permanent_address = $request->permanent_address;
      $Contact->name_of_employee = $request->name_of_employee;
      $Contact->office_address = $request->office_address;
      $Contact->town = $request->town;
      $Contact->communication_address = $request->communication_address;
      $Contact->place_of_birth = $request->place_of_birth;


      $Contact->contact_no = $request->contact_no;  
      $Contact->address = $request->address;     
      $Contact->city = $request->city;     
      $Contact->state = $request->state;     
      $Contact->country = $request->country;     
      $Contact->assigne = $request->assigne;     
      $Contact->sector = $request->sector; 
      $Contact->identification = $request->identification; 
      $Contact->status = $request->status; 
      $Contact->pep_indictaor = $request->indicatior;            
      $Contact->save();
    return redirect()->route('admin.business.contact.show')->with('success', 'Business Contact Update Successfully .');
    }



   

     public function destroy($id) {
        $a = Contact::find($id); 
        $a->delete(); //delete the User
        return redirect()->route('admin.business.contact.show')->with('success', 'Business Contact Delete Successfully.');
    }

    public function export(Request $request){
      $fileName = 'contacts.csv'; 
      $foundflag = false;
      $array     = [];
      $i         = 0;   
   

      $contacts = Contact::get(); 

       

       $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Name', 'Email', 'Mobile No');

            $callback = function() use($contacts, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($contacts as $contact) {
                
                $row['Name']           = $contact->firstname.' '.$contact->lastname;
                $row['Email']          = $contact->email;
                $row['Mobile No']      = $contact->contact_no;
                
            fputcsv($file, array( $row['Name'], $row['Email'], $row['Mobile No']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }

    
    
    

}

