<?php



namespace App\Http\Controllers\Admin\Audit;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\User;
use App\Models\Lead;
use App\Models\CallActivity;
use App\Models\Opportunity;
use App\Models\Sale;
use Validator;
use Image;
use Auth;


class ActivityController extends Controller{    

    public function index(Request $request){     
    $page_title = 'Calls';    
    $callActivities = CallActivity::where('user_id','=',Auth::user()->id)->get();             
    return view('admin/audit/calls/index', compact('page_title', 'callActivities','start_date','stop_date','follow_up'));    
   }


    public function create(Request $request,$id){                 
       $page_title = 'Add Call'; 
       return view('admin/audit/calls/add', compact('page_title','id'));    
      }

     public function store(Request $request){ 
      //dd($request);
      $CallActivity = new CallActivity;
      $CallActivity->user_id = Auth::user()->id;
      $CallActivity->lead_id = $request->lead_id;
      $CallActivity->subject = $request->subject;
      $CallActivity->start_date = $request->start_date;
      $CallActivity->follow_up = $request->follow_up;
      $CallActivity->duration = $request->duration;      
      $CallActivity->description = $request->description;
      $CallActivity->status = $request->status;
      $CallActivity->save();
     
      return redirect()->route('audit.assigned.leads.details',$request->lead_id)->with('success', 'Call Add Successfully.');

            
   }

 public function convert(Request $request){ 
     //dd($request);
      
      if($request->convert == 'Convert To opportunity'){      
      $Opportunity = new Opportunity;
      $Opportunity->user_id = Auth::user()->id;
      $Opportunity->lead_id = $request->lead_id;
      $Opportunity->insurance_id = $request->insurance;
      $Opportunity->insurance_name = $request->insurane_name;
      $Opportunity->price = $request->price;
      $Opportunity->expire = $request->expire;
      $Opportunity->save();
      $Lead = Lead::where('id', '=', $request->lead_id)->first(); 
      $Lead->status = 'Opportunity';
      $Lead->save();

      }else{

      $Sale = new Sale;
      $Sale->user_id = Auth::user()->id;
      $Sale->lead_id = $request->lead_id;
      $Sale->assigned_by_user_id = Lead::where('id','=',$request->lead_id)->pluck('assigned_by_user_id')->first();
      $Sale->insurance_id = $request->insurance;
      $Sale->insurance_name = $request->insurane_name;
      $Sale->price = $request->price;
      $Sale->expire = $request->expire;
      $Sale->save();
      $Lead = Lead::where('id', '=', $request->lead_id)->first();  
      $Lead->status = 'Progress';
      $Lead->save();
       
      return redirect()->route('audit.sales.create',$Sale->id)->with('success', 'Added Successfully.');
      }
          
      return redirect()->route('audit.assigned.leads.details',$request->lead_id)->with('success', 'Added Successfully.');

            
   }
     public function show($id) {
        $callActivity = CallActivity::where('id', '=', $id)->where('user_id', '=', Auth::user()->id)->first(); 
        //dd($callActivity);
        return view('admin/audit/calls/edit', compact('callActivity'));    
    }

     public function update(Request $request, $id) {
      //dd($request);
      $CallActivity = CallActivity::where('id', '=', $id)->first();
      $CallActivity->user_id = Auth::user()->id;
      $CallActivity->lead_id = $request->lead_id;
      $CallActivity->subject = $request->subject;
      $CallActivity->start_date = $request->start_date;
      $CallActivity->follow_up = $request->follow_up;
      $CallActivity->duration = $request->duration;      
      $CallActivity->description = $request->description;
      $CallActivity->status = $request->status;
      $CallActivity->save();
      

    return redirect()->route('audit.leads.call.show')->with('success', 'Call Update Successfully.');
    }

  

     public function destroy($id) {
        $c = CallActivity::find($id); 
        $c->delete();
        return redirect()->route('audit.leads.call.show')->with('success', 'Lead Call Delete Successfully.');
    }

     

    
    
    

}

