<?php



namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use App\Models\Agent;
use Validator;
use Image;


class AgentController extends Controller

{

    public function index(Request $request){ 
    $agents = Agent::get();
    $page_title = 'Manage Agents';
    if($request->search == 'true'){

          $agents = Agent::where('username','=',$request->username)
          ->where('email','=',$request->email)
          ->where('mobile','=',$request->mobile)
          ->where('firstname','=',$request->name)
          ->get();    

        }
        else{

         $agents = Agent::get();      
        }
    return view('admin/agent/index', compact('page_title', 'agents'));    
   }

     public function create(Request $request){ 
                
       $page_title = 'Add Agent';
       return view('admin/agent/add', compact('page_title'));    
      }

     public function store(Request $request){ 

      $Agent = new Agent;
      $Agent->username = $request->username;
      $Agent->password = Hash::make($request->password);
      $Agent->code = $request->code;
      $Agent->firstname = $request->firstname;
      $Agent->lastname = $request->lastname;
      $Agent->mobile = $request->mobile;
      $Agent->email = $request->email;
      $Agent->status = $request->get('status',0);
      $Agent->save();

       if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "agents." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/agents/'), $fileName);

            if ($Agent->image != 'photo.jpg' && is_file(public_path('uploads/agents/' . $Agent->image))) {
                unlink(public_path('uploads/agents/' . $Agent->image));
            }
            $Agent->image = $fileName;
            $Agent->save();
        }

        $data = array(
       'name' => $request->firstname.' '.$request->lastname,
       'email' => $request->email,
       'username' => $request->username,
       'password' => $request->password


    );
            $param = [
                'subject' => 'CRM: New Agent Registration.',
                'from' => ['name' => env('MAIL_FROM_NAME'), 'address' => env('MAIL_FROM_ADDRESS')],
                'view' => 'email_template',
                'data' => $data
            ];
           

    
     Mail::to($data['email'])->send(new SendMail($param));
     return redirect()->route('admin.agents.show')->with('success', 'Agent Add Successfully.');

            
   }

     public function show($id) {
        $agents = Agent::where('id', '=', $id)->first();        
        return view('admin/agent/edit', compact('agents'));    
    }

     public function update(Request $request, $id) {
            $Agent = Agent::where('id', '=', $id)->first();
            $Agent->username = $request->username;
            $Agent->password = Hash::make($request->password);
            $Agent->code = $request->code;
            $Agent->firstname = $request->firstname;
            $Agent->lastname = $request->lastname;
            $Agent->mobile = $request->mobile;
            $Agent->status = $request->get('status',0);
            $Agent->save();

         if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "agents." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/agents/'), $fileName);

            if ($Agent->image != 'photo.jpg' && is_file(public_path('uploads/agents/' . $Agent->image))) {
                unlink(public_path('uploads/agents/' . $Agent->image));
            }
            $Agent->image = $fileName;
            $Agent->save();
        }
         return redirect()->route('admin.agents.show')->with('success', 'Agent Update Successfully.');
    }


      public function destroy($id) {
        $a = Agent::find($id); 
        $a->delete(); //delete the Agent
        return redirect()->route('admin.agents.show')->with('success', 'Agent Delete Successfully.');
    }


    

}

