<?php

namespace App\Helpers\Route;


use Illuminate\Support\Facades\Route;


class ManagementRouteHelper
{
    public static function routes() {
        

    

    Route::group(['prefix' => 'management'], function () {   
        
    
    Route::group(['prefix' => 'leads'], function () {
    Route::any('', array('as' => 'management.leads.show', 'uses' => 'Admin\Management\LeadController@index'));
    Route::get('create', array('as' => 'management.leads.create', 'uses' => 'Admin\Management\LeadController@create'));
    Route::post('store', array('as' => 'management.leads.store', 'uses' => 'Admin\Management\LeadController@store'));
    Route::get('edit/{id}', array('as' => 'management.leads.edit', 'uses' => 'Admin\Management\LeadController@show'));
    Route::post('update/{id}', array('as' => 'management.leads.update', 'uses' => 'Admin\Management\LeadController@update'));
    Route::get('delete/{id}', array('as' => 'management.leads.delete', 'uses' => 'Admin\Management\LeadController@destroy'));
    Route::get('importExportView', array('as' => 'management.leads.import', 'uses' => 'Admin\Management\LeadController@importExportView'));
    Route::post('import', array('as' => 'management.leads.import.store', 'uses' => 'Admin\Management\LeadController@import'));

     Route::get('/export', array('as' => 'management.leads.exportCsv', 'uses' => 'Admin\Management\LeadController@exportCsv'));


    Route::any('/sales', array('as' => 'management.sales.show', 'uses' => 'Admin\Management\SaleController@index'));
    Route::any('crm/sales', array('as' => 'management.crm.sales.show', 'uses' => 'Admin\Management\SaleController@crmsales'));

    Route::post('/sales/store', array('as' => 'management.sales.store', 'uses' => 'Admin\Management\SaleController@store'));
    Route::get('/sales/create/{id}', array('as' => 'management.sales.create', 'uses' => 'Admin\Management\SaleController@create'));
    Route::any('detail/{id}', array('as' => 'management.sales.detail', 'uses' => 'Admin\Management\SaleController@details'));

    Route::get('sales/export', array('as' => 'management.sales.exportCsv', 'uses' => 'Admin\Management\SaleController@exportCsv'));
    Route::get('crm/sales/export', array('as' => 'management.crm.sales.exportCsv', 'uses' => 'Admin\Management\SaleController@exportCsv1'));


    //Route::any('/assigned', array('as' => 'management.assigned.Leads', 'uses' => 'Admin\TeamLead\LeadController@assignedLeads'));
    Route::get('/details/{id}', array('as' => 'management.assigned.leads.details', 'uses' => 'Admin\Management\LeadController@details'));

    Route::any('/call', array('as' => 'management.leads.call.show', 'uses' => 'Admin\Management\ActivityController@index'));

     Route::get('/call/export', array('as' => 'management.leads.call.exportCsv', 'uses' => 'Admin\Management\ActivityController@exportCsv'));

    Route::post('/call/store', array('as' => 'management.leads.call.store', 'uses' => 'Admin\Management\ActivityController@store'));
    Route::post('/call/convert', array('as' => 'management.leads.call.convert', 'uses' => 'Admin\Management\ActivityController@convert'));   



    });

     Route::group(['prefix' => 'opportunity'], function () {
     Route::any('/', array('as' => 'management.opportunity.show', 'uses' => 'Admin\Management\OpportunityController@index'));

     Route::get('create', array('as' => 'management.opportunity.create', 'uses' => 'Admin\Management\OpportunityController@create'));

     Route::post('store', array('as' => 'management.opportunity.store', 'uses' => 'Admin\Management\OpportunityController@store'));

    Route::get('edit/{id}', array('as' => 'management.opportunity.edit', 'uses' => 'Admin\Management\OpportunityController@show'));

     Route::post('update/{id}', array('as' => 'management.opportunity.update', 'uses' => 'Admin\Management\OpportunityController@update'));

     Route::get('delete/{id}', array('as' => 'management.opportunity.delete', 'uses' => 'Admin\Management\OpportunityController@destroy'));

     Route::get('export', array('as' => 'management.opportunity.exportCsv', 'uses' => 'Admin\Management\OpportunityController@exportCsv'));

      });





///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
     Route::group(['prefix' => 'business-info/accounts'], function () {
Route::any('', array('as' => 'management.business.account.show', 'uses' => 'Admin\Management\Business\AccountController@index'));
Route::get('create', array('as' => 'management.business.account.create', 'uses' => 'Admin\Management\Business\AccountController@create'));
Route::post('store', array('as' => 'management.business.account.store', 'uses' => 'Admin\Management\Business\AccountController@store'));
Route::get('edit/{id}', array('as' => 'management.business.account.edit', 'uses' => 'Admin\Management\Business\AccountController@show'));

Route::post('update/{id}', array('as' => 'management.business.account.update', 'uses' => 'Admin\Management\Business\AccountController@update'));

Route::get('delete/{id}', array('as' => 'management.business.account.delete', 'uses' => 'Admin\Management\Business\AccountController@destroy'));

Route::post('assign/{id}', array('as' => 'management.business.account.assign', 'uses' => 'Admin\Management\Business\AccountController@accountAssignToContact'));

Route::get('export', array('as' => 'management.business.account.exportCsv', 'uses' => 'Admin\Management\Business\AccountController@exportCsv'));

});

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 Route::group(['prefix' => 'business-info/contact'], function () {
 Route::any('', array('as' => 'management.business.contact.show', 'uses' => 'Admin\Management\Business\ContactController@index'));
 Route::get('create', array('as' => 'management.business.contact.create', 'uses' => 'Admin\Management\Business\ContactController@create'));
 Route::post('store', array('as' => 'management.business.contact.store', 'uses' => 'Admin\Management\Business\ContactController@store'));
 Route::get('edit/{id}', array('as' => 'management.business.contact.edit', 'uses' => 'Admin\Management\Business\ContactController@show'));
 Route::post('update/{id}', array('as' => 'management.business.contact.update', 'uses' => 'Admin\Management\Business\ContactController@update'));
 Route::get('delete/{id}', array('as' => 'management.business.contact.delete', 'uses' => 'Admin\Management\Business\ContactController@destroy'));

 Route::get('export', array('as' => 'management.business.contact.exportCsv', 'uses' => 'Admin\Management\Business\ContactController@exportCsv'));


});

 Route::group(['prefix' => 'renewals'], function () {

        Route::any('/', array('as' => 'management.renewal.show', 'uses' => 'Admin\Management\PolicyController@renewals'));
        Route::any('/export',array('as' => 'management.renewal.export', 'uses' => 'Admin\Management\PolicyController@export'));

        });


Route::group(['prefix' => 'tasks'], function () {
    Route::any('', array('as' => 'management.tasks.show', 'uses' => 'Admin\Management\Task\TaskController@index'));
    Route::get('create', array('as' => 'management.tasks.create', 'uses' => 'Admin\Management\Task\TaskController@create'));
    Route::post('store', array('as' => 'management.tasks.store', 'uses' => 'Admin\Management\Task\TaskController@store'));
    Route::get('edit/{id}', array('as' => 'management.tasks.edit', 'uses' => 'Admin\Management\Task\TaskController@show'));
    Route::post('update/{id}', array('as' => 'management.tasks.update', 'uses' => 'Admin\Management\Task\TaskController@update'));
    Route::get('delete/{id}', array('as' => 'management.tasks.delete', 'uses' => 'Admin\Management\Task\TaskController@destroy'));

    Route::get('notes/{id}', array('as' => 'management.tasks.notes.show', 'uses' => 'Admin\Management\Task\TaskController@ShowNotesdetails'));

    Route::get('/export', array('as' => 'management.tasks.exportCsv', 'uses' => 'Admin\Management\Task\TaskController@exportCsv'));

});

Route::group(['prefix' => 'myTasks'], function () {
    Route::any('/', array('as' => 'management.mytasks.show', 'uses' => 'Admin\Management\Task\TaskController@mytasks'));
    Route::get('/details/{id}', array('as' => 'management.mytasks.detail', 'uses' => 'Admin\Management\Task\TaskController@details'));

    Route::post('/details/update/{id}', array('as' => 'management.mytasks.detail.update', 'uses' => 'Admin\Management\Task\TaskController@detailUpdate'));

    Route::get('download/{id}', array('as' => 'management.mytasks.detail.download', 'uses' => 'Admin\Management\Task\TaskController@getDownload'));

    Route::get('export', array('as' => 'management.mytasks.exportCsv', 'uses' => 'Admin\Management\Task\TaskController@myTasksexportCsv'));

     });

     });           
     
    
    
    }
  }